/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.certificatemanager.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.certificatemanager.model.DomainValidation;
import java.util.List;

@SdkInternalApi
public class DomainValidationMarshaller {
    private static final MarshallingInfo<String> DOMAINNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DomainName").build();
    private static final MarshallingInfo<List> VALIDATIONEMAILS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ValidationEmails").build();
    private static final MarshallingInfo<String> VALIDATIONDOMAIN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ValidationDomain").build();
    private static final MarshallingInfo<String> VALIDATIONSTATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ValidationStatus").build();
    private static final DomainValidationMarshaller instance = new DomainValidationMarshaller();

    public static DomainValidationMarshaller getInstance() {
        return instance;
    }

    public void marshall(DomainValidation domainValidation, ProtocolMarshaller protocolMarshaller) {
        if (domainValidation == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)domainValidation.getDomainName(), DOMAINNAME_BINDING);
            protocolMarshaller.marshall(domainValidation.getValidationEmails(), VALIDATIONEMAILS_BINDING);
            protocolMarshaller.marshall((Object)domainValidation.getValidationDomain(), VALIDATIONDOMAIN_BINDING);
            protocolMarshaller.marshall((Object)domainValidation.getValidationStatus(), VALIDATIONSTATUS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

