/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.accessanalyzer.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.accessanalyzer.model.PathElement;
import com.amazonaws.services.accessanalyzer.model.Span;
import com.amazonaws.services.accessanalyzer.model.transform.LocationMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class Location
implements Serializable,
Cloneable,
StructuredPojo {
    private List<PathElement> path;
    private Span span;

    public List<PathElement> getPath() {
        return this.path;
    }

    public void setPath(Collection<PathElement> path) {
        if (path == null) {
            this.path = null;
            return;
        }
        this.path = new ArrayList<PathElement>(path);
    }

    public Location withPath(PathElement ... path) {
        if (this.path == null) {
            this.setPath(new ArrayList<PathElement>(path.length));
        }
        for (PathElement ele : path) {
            this.path.add(ele);
        }
        return this;
    }

    public Location withPath(Collection<PathElement> path) {
        this.setPath(path);
        return this;
    }

    public void setSpan(Span span) {
        this.span = span;
    }

    public Span getSpan() {
        return this.span;
    }

    public Location withSpan(Span span) {
        this.setSpan(span);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getPath() != null) {
            sb.append("Path: ").append(this.getPath()).append(",");
        }
        if (this.getSpan() != null) {
            sb.append("Span: ").append(this.getSpan());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Location)) {
            return false;
        }
        Location other = (Location)obj;
        if (other.getPath() == null ^ this.getPath() == null) {
            return false;
        }
        if (other.getPath() != null && !other.getPath().equals(this.getPath())) {
            return false;
        }
        if (other.getSpan() == null ^ this.getSpan() == null) {
            return false;
        }
        return other.getSpan() == null || other.getSpan().equals(this.getSpan());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getPath() == null ? 0 : this.getPath().hashCode());
        hashCode = 31 * hashCode + (this.getSpan() == null ? 0 : this.getSpan().hashCode());
        return hashCode;
    }

    public Location clone() {
        try {
            return (Location)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        LocationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

