/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.accessanalyzer.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.accessanalyzer.model.KmsGrantConstraints;
import com.amazonaws.services.accessanalyzer.model.KmsGrantOperation;
import com.amazonaws.services.accessanalyzer.model.transform.KmsGrantConfigurationMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class KmsGrantConfiguration
implements Serializable,
Cloneable,
StructuredPojo {
    private List<String> operations;
    private String granteePrincipal;
    private String retiringPrincipal;
    private KmsGrantConstraints constraints;
    private String issuingAccount;

    public List<String> getOperations() {
        return this.operations;
    }

    public void setOperations(Collection<String> operations) {
        if (operations == null) {
            this.operations = null;
            return;
        }
        this.operations = new ArrayList<String>(operations);
    }

    public KmsGrantConfiguration withOperations(String ... operations) {
        if (this.operations == null) {
            this.setOperations(new ArrayList<String>(operations.length));
        }
        for (String ele : operations) {
            this.operations.add(ele);
        }
        return this;
    }

    public KmsGrantConfiguration withOperations(Collection<String> operations) {
        this.setOperations(operations);
        return this;
    }

    public KmsGrantConfiguration withOperations(KmsGrantOperation ... operations) {
        ArrayList<String> operationsCopy = new ArrayList<String>(operations.length);
        for (KmsGrantOperation value : operations) {
            operationsCopy.add(value.toString());
        }
        if (this.getOperations() == null) {
            this.setOperations(operationsCopy);
        } else {
            this.getOperations().addAll(operationsCopy);
        }
        return this;
    }

    public void setGranteePrincipal(String granteePrincipal) {
        this.granteePrincipal = granteePrincipal;
    }

    public String getGranteePrincipal() {
        return this.granteePrincipal;
    }

    public KmsGrantConfiguration withGranteePrincipal(String granteePrincipal) {
        this.setGranteePrincipal(granteePrincipal);
        return this;
    }

    public void setRetiringPrincipal(String retiringPrincipal) {
        this.retiringPrincipal = retiringPrincipal;
    }

    public String getRetiringPrincipal() {
        return this.retiringPrincipal;
    }

    public KmsGrantConfiguration withRetiringPrincipal(String retiringPrincipal) {
        this.setRetiringPrincipal(retiringPrincipal);
        return this;
    }

    public void setConstraints(KmsGrantConstraints constraints) {
        this.constraints = constraints;
    }

    public KmsGrantConstraints getConstraints() {
        return this.constraints;
    }

    public KmsGrantConfiguration withConstraints(KmsGrantConstraints constraints) {
        this.setConstraints(constraints);
        return this;
    }

    public void setIssuingAccount(String issuingAccount) {
        this.issuingAccount = issuingAccount;
    }

    public String getIssuingAccount() {
        return this.issuingAccount;
    }

    public KmsGrantConfiguration withIssuingAccount(String issuingAccount) {
        this.setIssuingAccount(issuingAccount);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getOperations() != null) {
            sb.append("Operations: ").append(this.getOperations()).append(",");
        }
        if (this.getGranteePrincipal() != null) {
            sb.append("GranteePrincipal: ").append(this.getGranteePrincipal()).append(",");
        }
        if (this.getRetiringPrincipal() != null) {
            sb.append("RetiringPrincipal: ").append(this.getRetiringPrincipal()).append(",");
        }
        if (this.getConstraints() != null) {
            sb.append("Constraints: ").append(this.getConstraints()).append(",");
        }
        if (this.getIssuingAccount() != null) {
            sb.append("IssuingAccount: ").append(this.getIssuingAccount());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KmsGrantConfiguration)) {
            return false;
        }
        KmsGrantConfiguration other = (KmsGrantConfiguration)obj;
        if (other.getOperations() == null ^ this.getOperations() == null) {
            return false;
        }
        if (other.getOperations() != null && !other.getOperations().equals(this.getOperations())) {
            return false;
        }
        if (other.getGranteePrincipal() == null ^ this.getGranteePrincipal() == null) {
            return false;
        }
        if (other.getGranteePrincipal() != null && !other.getGranteePrincipal().equals(this.getGranteePrincipal())) {
            return false;
        }
        if (other.getRetiringPrincipal() == null ^ this.getRetiringPrincipal() == null) {
            return false;
        }
        if (other.getRetiringPrincipal() != null && !other.getRetiringPrincipal().equals(this.getRetiringPrincipal())) {
            return false;
        }
        if (other.getConstraints() == null ^ this.getConstraints() == null) {
            return false;
        }
        if (other.getConstraints() != null && !other.getConstraints().equals(this.getConstraints())) {
            return false;
        }
        if (other.getIssuingAccount() == null ^ this.getIssuingAccount() == null) {
            return false;
        }
        return other.getIssuingAccount() == null || other.getIssuingAccount().equals(this.getIssuingAccount());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getOperations() == null ? 0 : this.getOperations().hashCode());
        hashCode = 31 * hashCode + (this.getGranteePrincipal() == null ? 0 : this.getGranteePrincipal().hashCode());
        hashCode = 31 * hashCode + (this.getRetiringPrincipal() == null ? 0 : this.getRetiringPrincipal().hashCode());
        hashCode = 31 * hashCode + (this.getConstraints() == null ? 0 : this.getConstraints().hashCode());
        hashCode = 31 * hashCode + (this.getIssuingAccount() == null ? 0 : this.getIssuingAccount().hashCode());
        return hashCode;
    }

    public KmsGrantConfiguration clone() {
        try {
            return (KmsGrantConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        KmsGrantConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

