/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.accessanalyzer.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.accessanalyzer.model.FindingSummaryV2;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListFindingsV2Result
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<FindingSummaryV2> findings;
    private String nextToken;

    public List<FindingSummaryV2> getFindings() {
        return this.findings;
    }

    public void setFindings(Collection<FindingSummaryV2> findings) {
        if (findings == null) {
            this.findings = null;
            return;
        }
        this.findings = new ArrayList<FindingSummaryV2>(findings);
    }

    public ListFindingsV2Result withFindings(FindingSummaryV2 ... findings) {
        if (this.findings == null) {
            this.setFindings(new ArrayList<FindingSummaryV2>(findings.length));
        }
        for (FindingSummaryV2 ele : findings) {
            this.findings.add(ele);
        }
        return this;
    }

    public ListFindingsV2Result withFindings(Collection<FindingSummaryV2> findings) {
        this.setFindings(findings);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListFindingsV2Result withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getFindings() != null) {
            sb.append("Findings: ").append(this.getFindings()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListFindingsV2Result)) {
            return false;
        }
        ListFindingsV2Result other = (ListFindingsV2Result)obj;
        if (other.getFindings() == null ^ this.getFindings() == null) {
            return false;
        }
        if (other.getFindings() != null && !other.getFindings().equals(this.getFindings())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getFindings() == null ? 0 : this.getFindings().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public ListFindingsV2Result clone() {
        try {
            return (ListFindingsV2Result)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

