/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.accessanalyzer.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.accessanalyzer.model.TrailProperties;
import com.amazonaws.services.accessanalyzer.model.transform.CloudTrailPropertiesMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class CloudTrailProperties
implements Serializable,
Cloneable,
StructuredPojo {
    private Date endTime;
    private Date startTime;
    private List<TrailProperties> trailProperties;

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public CloudTrailProperties withEndTime(Date endTime) {
        this.setEndTime(endTime);
        return this;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public CloudTrailProperties withStartTime(Date startTime) {
        this.setStartTime(startTime);
        return this;
    }

    public List<TrailProperties> getTrailProperties() {
        return this.trailProperties;
    }

    public void setTrailProperties(Collection<TrailProperties> trailProperties) {
        if (trailProperties == null) {
            this.trailProperties = null;
            return;
        }
        this.trailProperties = new ArrayList<TrailProperties>(trailProperties);
    }

    public CloudTrailProperties withTrailProperties(TrailProperties ... trailProperties) {
        if (this.trailProperties == null) {
            this.setTrailProperties(new ArrayList<TrailProperties>(trailProperties.length));
        }
        for (TrailProperties ele : trailProperties) {
            this.trailProperties.add(ele);
        }
        return this;
    }

    public CloudTrailProperties withTrailProperties(Collection<TrailProperties> trailProperties) {
        this.setTrailProperties(trailProperties);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getEndTime() != null) {
            sb.append("EndTime: ").append(this.getEndTime()).append(",");
        }
        if (this.getStartTime() != null) {
            sb.append("StartTime: ").append(this.getStartTime()).append(",");
        }
        if (this.getTrailProperties() != null) {
            sb.append("TrailProperties: ").append(this.getTrailProperties());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CloudTrailProperties)) {
            return false;
        }
        CloudTrailProperties other = (CloudTrailProperties)obj;
        if (other.getEndTime() == null ^ this.getEndTime() == null) {
            return false;
        }
        if (other.getEndTime() != null && !other.getEndTime().equals(this.getEndTime())) {
            return false;
        }
        if (other.getStartTime() == null ^ this.getStartTime() == null) {
            return false;
        }
        if (other.getStartTime() != null && !other.getStartTime().equals(this.getStartTime())) {
            return false;
        }
        if (other.getTrailProperties() == null ^ this.getTrailProperties() == null) {
            return false;
        }
        return other.getTrailProperties() == null || other.getTrailProperties().equals(this.getTrailProperties());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getEndTime() == null ? 0 : this.getEndTime().hashCode());
        hashCode = 31 * hashCode + (this.getStartTime() == null ? 0 : this.getStartTime().hashCode());
        hashCode = 31 * hashCode + (this.getTrailProperties() == null ? 0 : this.getTrailProperties().hashCode());
        return hashCode;
    }

    public CloudTrailProperties clone() {
        try {
            return (CloudTrailProperties)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CloudTrailPropertiesMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

