/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.accessanalyzer.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.accessanalyzer.model.FindingStatus;
import com.amazonaws.services.accessanalyzer.model.ResourceType;
import com.amazonaws.services.accessanalyzer.model.transform.FindingSummaryMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FindingSummary
implements Serializable,
Cloneable,
StructuredPojo {
    private List<String> action;
    private Date analyzedAt;
    private Map<String, String> condition;
    private Date createdAt;
    private String error;
    private String id;
    private Boolean isPublic;
    private Map<String, String> principal;
    private String resource;
    private String resourceOwnerAccount;
    private String resourceType;
    private String status;
    private Date updatedAt;

    public List<String> getAction() {
        return this.action;
    }

    public void setAction(Collection<String> action) {
        if (action == null) {
            this.action = null;
            return;
        }
        this.action = new ArrayList<String>(action);
    }

    public FindingSummary withAction(String ... action) {
        if (this.action == null) {
            this.setAction(new ArrayList<String>(action.length));
        }
        for (String ele : action) {
            this.action.add(ele);
        }
        return this;
    }

    public FindingSummary withAction(Collection<String> action) {
        this.setAction(action);
        return this;
    }

    public void setAnalyzedAt(Date analyzedAt) {
        this.analyzedAt = analyzedAt;
    }

    public Date getAnalyzedAt() {
        return this.analyzedAt;
    }

    public FindingSummary withAnalyzedAt(Date analyzedAt) {
        this.setAnalyzedAt(analyzedAt);
        return this;
    }

    public Map<String, String> getCondition() {
        return this.condition;
    }

    public void setCondition(Map<String, String> condition) {
        this.condition = condition;
    }

    public FindingSummary withCondition(Map<String, String> condition) {
        this.setCondition(condition);
        return this;
    }

    public FindingSummary addConditionEntry(String key, String value) {
        if (null == this.condition) {
            this.condition = new HashMap<String, String>();
        }
        if (this.condition.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.condition.put(key, value);
        return this;
    }

    public FindingSummary clearConditionEntries() {
        this.condition = null;
        return this;
    }

    public void setCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public FindingSummary withCreatedAt(Date createdAt) {
        this.setCreatedAt(createdAt);
        return this;
    }

    public void setError(String error) {
        this.error = error;
    }

    public String getError() {
        return this.error;
    }

    public FindingSummary withError(String error) {
        this.setError(error);
        return this;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public FindingSummary withId(String id) {
        this.setId(id);
        return this;
    }

    public void setIsPublic(Boolean isPublic) {
        this.isPublic = isPublic;
    }

    public Boolean getIsPublic() {
        return this.isPublic;
    }

    public FindingSummary withIsPublic(Boolean isPublic) {
        this.setIsPublic(isPublic);
        return this;
    }

    public Boolean isPublic() {
        return this.isPublic;
    }

    public Map<String, String> getPrincipal() {
        return this.principal;
    }

    public void setPrincipal(Map<String, String> principal) {
        this.principal = principal;
    }

    public FindingSummary withPrincipal(Map<String, String> principal) {
        this.setPrincipal(principal);
        return this;
    }

    public FindingSummary addPrincipalEntry(String key, String value) {
        if (null == this.principal) {
            this.principal = new HashMap<String, String>();
        }
        if (this.principal.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.principal.put(key, value);
        return this;
    }

    public FindingSummary clearPrincipalEntries() {
        this.principal = null;
        return this;
    }

    public void setResource(String resource) {
        this.resource = resource;
    }

    public String getResource() {
        return this.resource;
    }

    public FindingSummary withResource(String resource) {
        this.setResource(resource);
        return this;
    }

    public void setResourceOwnerAccount(String resourceOwnerAccount) {
        this.resourceOwnerAccount = resourceOwnerAccount;
    }

    public String getResourceOwnerAccount() {
        return this.resourceOwnerAccount;
    }

    public FindingSummary withResourceOwnerAccount(String resourceOwnerAccount) {
        this.setResourceOwnerAccount(resourceOwnerAccount);
        return this;
    }

    public void setResourceType(String resourceType) {
        this.resourceType = resourceType;
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public FindingSummary withResourceType(String resourceType) {
        this.setResourceType(resourceType);
        return this;
    }

    public FindingSummary withResourceType(ResourceType resourceType) {
        this.resourceType = resourceType.toString();
        return this;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getStatus() {
        return this.status;
    }

    public FindingSummary withStatus(String status) {
        this.setStatus(status);
        return this;
    }

    public FindingSummary withStatus(FindingStatus status) {
        this.status = status.toString();
        return this;
    }

    public void setUpdatedAt(Date updatedAt) {
        this.updatedAt = updatedAt;
    }

    public Date getUpdatedAt() {
        return this.updatedAt;
    }

    public FindingSummary withUpdatedAt(Date updatedAt) {
        this.setUpdatedAt(updatedAt);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAction() != null) {
            sb.append("Action: ").append(this.getAction()).append(",");
        }
        if (this.getAnalyzedAt() != null) {
            sb.append("AnalyzedAt: ").append(this.getAnalyzedAt()).append(",");
        }
        if (this.getCondition() != null) {
            sb.append("Condition: ").append(this.getCondition()).append(",");
        }
        if (this.getCreatedAt() != null) {
            sb.append("CreatedAt: ").append(this.getCreatedAt()).append(",");
        }
        if (this.getError() != null) {
            sb.append("Error: ").append(this.getError()).append(",");
        }
        if (this.getId() != null) {
            sb.append("Id: ").append(this.getId()).append(",");
        }
        if (this.getIsPublic() != null) {
            sb.append("IsPublic: ").append(this.getIsPublic()).append(",");
        }
        if (this.getPrincipal() != null) {
            sb.append("Principal: ").append(this.getPrincipal()).append(",");
        }
        if (this.getResource() != null) {
            sb.append("Resource: ").append(this.getResource()).append(",");
        }
        if (this.getResourceOwnerAccount() != null) {
            sb.append("ResourceOwnerAccount: ").append(this.getResourceOwnerAccount()).append(",");
        }
        if (this.getResourceType() != null) {
            sb.append("ResourceType: ").append(this.getResourceType()).append(",");
        }
        if (this.getStatus() != null) {
            sb.append("Status: ").append(this.getStatus()).append(",");
        }
        if (this.getUpdatedAt() != null) {
            sb.append("UpdatedAt: ").append(this.getUpdatedAt());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FindingSummary)) {
            return false;
        }
        FindingSummary other = (FindingSummary)obj;
        if (other.getAction() == null ^ this.getAction() == null) {
            return false;
        }
        if (other.getAction() != null && !other.getAction().equals(this.getAction())) {
            return false;
        }
        if (other.getAnalyzedAt() == null ^ this.getAnalyzedAt() == null) {
            return false;
        }
        if (other.getAnalyzedAt() != null && !other.getAnalyzedAt().equals(this.getAnalyzedAt())) {
            return false;
        }
        if (other.getCondition() == null ^ this.getCondition() == null) {
            return false;
        }
        if (other.getCondition() != null && !other.getCondition().equals(this.getCondition())) {
            return false;
        }
        if (other.getCreatedAt() == null ^ this.getCreatedAt() == null) {
            return false;
        }
        if (other.getCreatedAt() != null && !other.getCreatedAt().equals(this.getCreatedAt())) {
            return false;
        }
        if (other.getError() == null ^ this.getError() == null) {
            return false;
        }
        if (other.getError() != null && !other.getError().equals(this.getError())) {
            return false;
        }
        if (other.getId() == null ^ this.getId() == null) {
            return false;
        }
        if (other.getId() != null && !other.getId().equals(this.getId())) {
            return false;
        }
        if (other.getIsPublic() == null ^ this.getIsPublic() == null) {
            return false;
        }
        if (other.getIsPublic() != null && !other.getIsPublic().equals(this.getIsPublic())) {
            return false;
        }
        if (other.getPrincipal() == null ^ this.getPrincipal() == null) {
            return false;
        }
        if (other.getPrincipal() != null && !other.getPrincipal().equals(this.getPrincipal())) {
            return false;
        }
        if (other.getResource() == null ^ this.getResource() == null) {
            return false;
        }
        if (other.getResource() != null && !other.getResource().equals(this.getResource())) {
            return false;
        }
        if (other.getResourceOwnerAccount() == null ^ this.getResourceOwnerAccount() == null) {
            return false;
        }
        if (other.getResourceOwnerAccount() != null && !other.getResourceOwnerAccount().equals(this.getResourceOwnerAccount())) {
            return false;
        }
        if (other.getResourceType() == null ^ this.getResourceType() == null) {
            return false;
        }
        if (other.getResourceType() != null && !other.getResourceType().equals(this.getResourceType())) {
            return false;
        }
        if (other.getStatus() == null ^ this.getStatus() == null) {
            return false;
        }
        if (other.getStatus() != null && !other.getStatus().equals(this.getStatus())) {
            return false;
        }
        if (other.getUpdatedAt() == null ^ this.getUpdatedAt() == null) {
            return false;
        }
        return other.getUpdatedAt() == null || other.getUpdatedAt().equals(this.getUpdatedAt());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAction() == null ? 0 : this.getAction().hashCode());
        hashCode = 31 * hashCode + (this.getAnalyzedAt() == null ? 0 : this.getAnalyzedAt().hashCode());
        hashCode = 31 * hashCode + (this.getCondition() == null ? 0 : this.getCondition().hashCode());
        hashCode = 31 * hashCode + (this.getCreatedAt() == null ? 0 : this.getCreatedAt().hashCode());
        hashCode = 31 * hashCode + (this.getError() == null ? 0 : this.getError().hashCode());
        hashCode = 31 * hashCode + (this.getId() == null ? 0 : this.getId().hashCode());
        hashCode = 31 * hashCode + (this.getIsPublic() == null ? 0 : this.getIsPublic().hashCode());
        hashCode = 31 * hashCode + (this.getPrincipal() == null ? 0 : this.getPrincipal().hashCode());
        hashCode = 31 * hashCode + (this.getResource() == null ? 0 : this.getResource().hashCode());
        hashCode = 31 * hashCode + (this.getResourceOwnerAccount() == null ? 0 : this.getResourceOwnerAccount().hashCode());
        hashCode = 31 * hashCode + (this.getResourceType() == null ? 0 : this.getResourceType().hashCode());
        hashCode = 31 * hashCode + (this.getStatus() == null ? 0 : this.getStatus().hashCode());
        hashCode = 31 * hashCode + (this.getUpdatedAt() == null ? 0 : this.getUpdatedAt().hashCode());
        return hashCode;
    }

    public FindingSummary clone() {
        try {
            return (FindingSummary)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        FindingSummaryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

