/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.devicefarm;

import com.amazonaws.devicefarm.DeviceFarmException;
import com.amazonaws.devicefarm.extension.DeviceFarmExtension;
import com.amazonaws.services.devicefarm.AWSDeviceFarm;
import com.amazonaws.services.devicefarm.model.DevicePool;
import com.amazonaws.services.devicefarm.model.ListDevicePoolsRequest;
import com.amazonaws.services.devicefarm.model.ListDevicePoolsResult;
import com.amazonaws.services.devicefarm.model.ListProjectsRequest;
import com.amazonaws.services.devicefarm.model.ListProjectsResult;
import com.amazonaws.services.devicefarm.model.Project;
import java.util.ArrayList;
import java.util.List;

public class DeviceFarmUtils {
    private final DeviceFarmExtension extension;
    private final AWSDeviceFarm api;

    public DeviceFarmUtils(AWSDeviceFarm api, DeviceFarmExtension extension) {
        this.extension = extension;
        this.api = api;
    }

    public List<Project> getProjects() {
        ListProjectsResult result = this.api.listProjects(new ListProjectsRequest());
        if (result == null) {
            return new ArrayList<Project>();
        }
        return result.getProjects();
    }

    public Project findProjectByName(String projectName) {
        for (Project p : this.getProjects()) {
            if (!p.getName().equals(projectName)) continue;
            return p;
        }
        throw new DeviceFarmException(String.format("Project '%s' not found.", projectName));
    }

    public List<DevicePool> getDevicePools(Project project) {
        ListDevicePoolsResult poolsResult = this.api.listDevicePools(new ListDevicePoolsRequest().withArn(project.getArn()));
        return poolsResult.getDevicePools();
    }

    public DevicePool findDevicePoolByName(Project project, String devicePoolName) {
        List<DevicePool> pools = this.getDevicePools(project);
        for (DevicePool dp : pools) {
            if (!dp.getName().equals(devicePoolName)) continue;
            return dp;
        }
        throw new DeviceFarmException(String.format("DevicePool '%s' not found.", devicePoolName));
    }

    public String getRunUrlFromArn(String arn) {
        String projectId = DeviceFarmUtils.getProjectIdFromArn(arn);
        String runId = DeviceFarmUtils.getRunIdFromArn(arn);
        return String.format(this.extension.getConsoleUrl(), projectId, runId);
    }

    public static String getRunIdFromArn(String arn) {
        String[] projectRunId = DeviceFarmUtils.splitRunArn(arn);
        return projectRunId[1];
    }

    public static String getProjectIdFromArn(String arn) {
        String[] projectRunId = DeviceFarmUtils.splitRunArn(arn);
        return projectRunId[0];
    }

    public static String[] splitRunArn(String arn) {
        return arn.split(":")[6].split("/");
    }
}

