/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.devicefarm;

import com.amazonaws.devicefarm.DeviceFarmException;
import com.amazonaws.services.devicefarm.AWSDeviceFarmClient;
import com.amazonaws.services.devicefarm.model.CreateUploadRequest;
import com.amazonaws.services.devicefarm.model.GetUploadRequest;
import com.amazonaws.services.devicefarm.model.GetUploadResult;
import com.amazonaws.services.devicefarm.model.Project;
import com.amazonaws.services.devicefarm.model.Upload;
import com.amazonaws.services.devicefarm.model.UploadType;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.FileEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.gradle.api.logging.Logger;

public class DeviceFarmUploader {
    private final AWSDeviceFarmClient api;
    private final Logger logger;
    private final ExecutorService uploadExecutor;

    public DeviceFarmUploader(AWSDeviceFarmClient api, Logger logger) {
        this.api = api;
        this.logger = logger;
        this.uploadExecutor = Executors.newCachedThreadPool();
    }

    public Upload upload(File file, Project project, UploadType uploadType) {
        CloseableHttpResponse response;
        if (!file.exists() || !file.canRead()) {
            throw new DeviceFarmException(String.format("File %s does not exist or is not readable", file));
        }
        CreateUploadRequest appUploadRequest = new CreateUploadRequest().withName(file.getName()).withProjectArn(project.getArn()).withContentType("application/octet-stream").withType(uploadType.toString());
        Upload upload = this.api.createUpload(appUploadRequest).getUpload();
        CloseableHttpClient httpClient = HttpClients.createDefault();
        HttpPut httpPut = new HttpPut(upload.getUrl());
        httpPut.setHeader("Content-Type", upload.getContentType());
        FileEntity entity = new FileEntity(file);
        httpPut.setEntity((HttpEntity)entity);
        this.writeToLog(String.format("Uploading %s to S3", file.getName()));
        try {
            response = httpClient.execute((HttpUriRequest)httpPut);
        }
        catch (IOException e) {
            throw new DeviceFarmException(String.format("Error uploading artifact %s", file), e);
        }
        if (response.getStatusLine().getStatusCode() != 200) {
            throw new DeviceFarmException(String.format("Upload returned non-200 responses: %s", response.getStatusLine().getStatusCode()));
        }
        this.waitForUpload(file, upload);
        return upload;
    }

    public Collection<Upload> batchUpload(List<File> artifacts, final Project project, final UploadType uploadType) {
        ArrayList futures = Lists.newArrayList();
        for (final File file : artifacts) {
            futures.add(this.uploadExecutor.submit(new Callable<Upload>(){

                @Override
                public Upload call() throws Exception {
                    return DeviceFarmUploader.this.upload(file, project, uploadType);
                }
            }));
        }
        ArrayList uploads = Lists.newArrayList();
        for (Future f : futures) {
            try {
                uploads.add(f.get());
            }
            catch (Exception e) {
                throw new DeviceFarmException(e);
            }
        }
        return uploads;
    }

    private void waitForUpload(File file, Upload upload) {
        GetUploadRequest describeUploadRequest;
        GetUploadResult describeUploadResult;
        String status;
        while (!"SUCCEEDED".equalsIgnoreCase(status = (describeUploadResult = this.api.getUpload(describeUploadRequest = new GetUploadRequest().withArn(upload.getArn()))).getUpload().getStatus())) {
            if ("FAILED".equalsIgnoreCase(status)) {
                throw new DeviceFarmException(String.format("Upload %s failed!", upload.getName()));
            }
            try {
                this.writeToLog(String.format("Waiting for upload %s to be ready (current status: %s)", file.getName(), status));
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                break;
            }
        }
    }

    private void writeToLog(String msg) {
        this.logger.info(msg);
    }
}

