/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.devicefarm;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.STSAssumeRoleSessionCredentialsProvider;
import com.amazonaws.devicefarm.DeviceFarmException;
import com.amazonaws.devicefarm.DeviceFarmServer;
import com.amazonaws.devicefarm.extension.Authentication;
import com.amazonaws.devicefarm.extension.DeviceFarmExtension;
import com.amazonaws.services.devicefarm.AWSDeviceFarmClient;
import java.io.IOException;
import java.util.Properties;
import org.apache.commons.lang3.RandomStringUtils;
import org.gradle.api.logging.Logger;

public class DeviceFarmClientFactory {
    final String pluginVersion = DeviceFarmClientFactory.readPluginVersion();

    public DeviceFarmClientFactory(Logger logger) {
        logger.lifecycle("AWS Device Farm Plugin version " + this.pluginVersion);
    }

    public AWSDeviceFarmClient initializeApiClient(DeviceFarmExtension extension) {
        String roleArn = extension.getAuthentication().getRoleArn();
        Authentication credentials = extension.getAuthentication();
        if (roleArn != null) {
            STSAssumeRoleSessionCredentialsProvider sts = new STSAssumeRoleSessionCredentialsProvider.Builder(roleArn, RandomStringUtils.randomAlphanumeric((int)8)).build();
            credentials = sts.getCredentials();
        }
        ClientConfiguration clientConfiguration = new ClientConfiguration().withUserAgent(String.format(extension.getUserAgent(), this.pluginVersion));
        AWSDeviceFarmClient apiClient = new AWSDeviceFarmClient((AWSCredentials)credentials, clientConfiguration);
        apiClient.setServiceNameIntern("devicefarm");
        if (extension.getEndpointOverride() != null) {
            apiClient.setEndpoint(extension.getEndpointOverride());
        }
        return apiClient;
    }

    private static String readPluginVersion() {
        try {
            Properties props = new Properties();
            props.load(DeviceFarmServer.class.getResourceAsStream("/META-INF/gradle-plugins/version.properties"));
            return props.getProperty("version");
        }
        catch (IOException e) {
            throw new DeviceFarmException("Unable to read version", e);
        }
    }
}

