/*
 * Decompiled with CFR 0.152.
 */
import com.amazonaws.services.codebuild.model.ArtifactNamespace;
import com.amazonaws.services.codebuild.model.ArtifactPackaging;
import com.amazonaws.services.codebuild.model.ArtifactsType;
import com.amazonaws.services.codebuild.model.CacheType;
import com.amazonaws.services.codebuild.model.ComputeType;
import com.amazonaws.services.codebuild.model.EnvironmentType;
import com.amazonaws.services.codebuild.model.EnvironmentVariable;
import com.amazonaws.services.codebuild.model.InvalidInputException;
import com.amazonaws.services.codebuild.model.SourceType;
import com.amazonaws.services.logs.AWSLogsClient;
import com.amazonaws.services.s3.model.BucketVersioningConfiguration;
import enums.SourceControlType;
import hudson.FilePath;
import java.util.Collection;
import org.apache.commons.lang.StringEscapeUtils;

public class Validation {
    public static final String validSourceUrlPrefix = "https://";
    public static final String invalidArtifactTypeError = "Artifact type override must be one of 'NO_ARTIFACTS', 'S3', ''";
    public static final String invalidArtifactsPackagingError = "Artifact packaging override must be one of 'NONE', 'ZIP', ''";
    public static final String invalidArtifactNamespaceTypeError = "Artifact namespace override must be one of 'NONE', 'BUILD_ID', ''";
    public static final String invalidTimeoutOverrideError = "Build timeout override must be a number between 5 and 480 (minutes)";
    public static final String invalidDefaultCredentialsError = "AWS credentials couldn't be loaded from the default provider chain";
    public static final String invalidRegionError = "Enter a valid AWS region";
    public static final String invalidProxyError = "Enter a valid proxy host and port (greater than zero)";
    public static final String invalidCredTypeError = "Invalid credentialsType option; must be 'jenkins' or 'keys'";
    public static final String invalidCredentialsIdError = "Invalid credentials ID. Verify that the credentials are of type CodeBuildCredentials and are accessible in this project.";
    public static final String unableToGetJobFolder = "Unable to retrieve folder for this job.";
    public static final String basicAWSCredentials = "Using given AWS access and secret key for authorization";
    public static final String defaultChainCredentials = "Using credentials provided by the DefaultAWSCredentialsProviderChain for authorization";
    public static final String IAMRoleCredentials = "Authorizing with the IAM role defined in credentials ";
    public static final String invalidSourceTypeError = "Source type override must be one of 'CODECOMMIT', 'S3', 'GITHUB', 'GITHUB_ENTERPRISE', 'BITBUCKET'";
    public static final String invalidComputeTypeError = "Compute type override must be one of 'BUILD_GENERAL1_SMALL', 'BUILD_GENERAL1_MEDIUM', 'BUILD_GENERAL1_LARGE'";
    public static final String invalidEnvironmentTypeError = "Environment type override must be one of 'LINUX_CONTAINER', 'WINDOWS_CONTAINER'";
    public static final String invalidCacheTypeError = "Cache type override must be one of 'S3', 'NO_CACHE'";
    public static final String projectRequiredError = "CodeBuild project name is required";
    public static final String sourceControlTypeRequiredError = "Source control type is required and must be 'jenkins' or 'project'";

    public static String sanitize(String s) {
        if (s == null) {
            return "";
        }
        return StringEscapeUtils.escapeSql((String)StringEscapeUtils.escapeHtml((String)s.trim()));
    }

    public static Integer parseInt(String s) {
        if (s == null || s.isEmpty()) {
            return null;
        }
        return Integer.parseInt(s);
    }

    public static String sanitizeYAML(String s) {
        if (s == null) {
            return "";
        }
        return s.replace("\t", " ");
    }

    public static String checkCodeBuilderConfig(CodeBuilder cb) {
        String projectName = cb.getParameterized(cb.getProjectName());
        if (projectName == null || projectName.isEmpty()) {
            return projectRequiredError;
        }
        String sourceControlType = cb.getParameterized(cb.getSourceControlType());
        if (!sourceControlType.equals(SourceControlType.JenkinsSource.toString()) && !sourceControlType.equals(SourceControlType.ProjectSource.toString())) {
            return sourceControlTypeRequiredError;
        }
        return "";
    }

    public static String checkCodeBuilderStartBuildOverridesConfig(CodeBuilder cb) {
        String timeout;
        String cacheTypeOverride;
        String environmentTypeOverride;
        String computeTypeOverride;
        String sourceTypeOverride;
        String artifactNamespaceOverride;
        String artifactPackagingOverride;
        String artifactTypeOverride = cb.getParameterized(cb.getArtifactTypeOverride());
        if (!artifactTypeOverride.isEmpty()) {
            try {
                ArtifactsType.fromValue((String)artifactTypeOverride);
            }
            catch (IllegalArgumentException e) {
                return invalidArtifactTypeError;
            }
        }
        if (!(artifactPackagingOverride = cb.getParameterized(cb.getArtifactPackagingOverride())).isEmpty()) {
            try {
                ArtifactPackaging.fromValue((String)artifactPackagingOverride);
            }
            catch (IllegalArgumentException e) {
                return invalidArtifactsPackagingError;
            }
        }
        if (!(artifactNamespaceOverride = cb.getParameterized(cb.getArtifactNamespaceOverride())).isEmpty()) {
            try {
                ArtifactNamespace.fromValue((String)artifactNamespaceOverride);
            }
            catch (IllegalArgumentException e) {
                return invalidArtifactNamespaceTypeError;
            }
        }
        if (!(sourceTypeOverride = cb.getParameterized(cb.getSourceTypeOverride())).isEmpty()) {
            try {
                SourceType.fromValue((String)sourceTypeOverride);
            }
            catch (IllegalArgumentException e) {
                return invalidSourceTypeError;
            }
        }
        if (!(computeTypeOverride = cb.getParameterized(cb.getComputeTypeOverride())).isEmpty()) {
            try {
                ComputeType.fromValue((String)computeTypeOverride);
            }
            catch (IllegalArgumentException e) {
                return invalidComputeTypeError;
            }
        }
        if (!(environmentTypeOverride = cb.getParameterized(cb.getEnvironmentTypeOverride())).isEmpty()) {
            try {
                EnvironmentType.fromValue((String)environmentTypeOverride);
            }
            catch (IllegalArgumentException e) {
                return invalidEnvironmentTypeError;
            }
        }
        if (!(cacheTypeOverride = cb.getParameterized(cb.getCacheTypeOverride())).isEmpty()) {
            try {
                CacheType.fromValue((String)cacheTypeOverride);
            }
            catch (IllegalArgumentException e) {
                return invalidCacheTypeError;
            }
        }
        if ((timeout = cb.getParameterized(cb.getBuildTimeoutOverride())) != null && !timeout.isEmpty()) {
            Integer t;
            try {
                t = Integer.parseInt(timeout);
            }
            catch (NumberFormatException e) {
                return invalidTimeoutOverrideError;
            }
            if (t < 5 || t > 480) {
                return invalidTimeoutOverrideError;
            }
        }
        return "";
    }

    public static boolean envVariablesHaveRestrictedPrefix(Collection<EnvironmentVariable> envVariables) {
        for (EnvironmentVariable e : envVariables) {
            if (!e.getName().startsWith("CODEBUILD_")) continue;
            return true;
        }
        return false;
    }

    public static boolean checkCloudWatchMonitorConfig(AWSLogsClient client) {
        return client != null;
    }

    public static void checkS3SourceUploaderConfig(FilePath workspace) throws Exception {
        if (workspace == null) {
            throw new Exception("Null workspace for project.");
        }
    }

    public static boolean checkSourceTypeS3(String sourceType) {
        return sourceType != null && sourceType.equals("S3");
    }

    public static boolean checkBucketIsVersioned(String bucketName, AWSClientFactory awsClientFactory) {
        BucketVersioningConfiguration bucketVersioningConfig = awsClientFactory.getS3Client().getBucketVersioningConfiguration(bucketName);
        return bucketVersioningConfig.getStatus().equals("Enabled");
    }

    public static void checkAWSClientFactoryJenkinsCredentialsConfig(String credentialsId) throws InvalidInputException {
        if (credentialsId == null || credentialsId.isEmpty()) {
            throw new InvalidInputException(invalidCredentialsIdError);
        }
    }

    public static void checkAWSClientFactoryRegionConfig(String region) throws InvalidInputException {
        if (region.isEmpty()) {
            throw new InvalidInputException(invalidRegionError);
        }
    }

    public static void checkAWSClientFactoryProxyConfig(String proxyHost, String proxyPort) throws InvalidInputException {
        Integer proxyPortInt;
        if (proxyHost != null && !proxyHost.isEmpty() && (proxyPortInt = Validation.parseInt(proxyPort)) != null && proxyPortInt < 0) {
            throw new InvalidInputException(invalidProxyError);
        }
    }
}

