/*
 * Decompiled with CFR 0.152.
 */
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.PutObjectResult;
import hudson.FilePath;
import hudson.model.TaskListener;
import java.beans.ConstructorProperties;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Paths;
import java.util.List;
import java.util.UUID;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.codec.Charsets;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.digest.DigestUtils;

public class S3DataManager {
    private final AmazonS3Client s3Client;
    private final String s3InputBucket;
    private final String s3InputKey;
    private final String sseAlgorithm;
    public static final String zipSourceError = "zipSource usage: prefixToTrim must be contained in the given directory.";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UploadToS3Output uploadSourceToS3(TaskListener listener, FilePath workspace) throws Exception {
        PutObjectResult putObjectResult;
        PutObjectRequest putObjectRequest;
        String zipFileMD5;
        Throwable throwable;
        Validation.checkS3SourceUploaderConfig(workspace);
        String zipFileName = this.s3InputKey;
        String sourceFilePath = workspace.getRemote();
        String zipFilePath = sourceFilePath.substring(0, sourceFilePath.lastIndexOf(File.separator) + 1) + UUID.randomUUID().toString() + "-" + zipFileName;
        FilePath jenkinsZipFile = new FilePath(workspace, zipFilePath);
        try (OutputStream zipFileOutputStream = jenkinsZipFile.write();){
            throwable = null;
            try (ZipOutputStream out = new ZipOutputStream(zipFileOutputStream);){
                S3DataManager.zipSource(workspace, sourceFilePath, out, sourceFilePath);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        ObjectMetadata objectMetadata = new ObjectMetadata();
        throwable = null;
        try (InputStream zipFileInputStream = jenkinsZipFile.read();){
            zipFileMD5 = new String(Base64.encodeBase64((byte[])DigestUtils.md5((InputStream)zipFileInputStream)), Charsets.UTF_8);
            objectMetadata.setContentMD5(zipFileMD5);
            objectMetadata.setContentLength(jenkinsZipFile.length());
            if (!this.sseAlgorithm.isEmpty()) {
                objectMetadata.setSSEAlgorithm(ObjectMetadata.AES_256_SERVER_SIDE_ENCRYPTION);
            }
        }
        catch (Throwable throwable3) {
            throwable = throwable3;
            throw throwable3;
        }
        try (InputStream zipFileInputStream = jenkinsZipFile.read();){
            putObjectRequest = new PutObjectRequest(this.s3InputBucket, this.s3InputKey, zipFileInputStream, objectMetadata);
            putObjectRequest.setMetadata(objectMetadata);
            LoggingHelper.log(listener, "Uploading code to S3 at location " + putObjectRequest.getBucketName() + "/" + putObjectRequest.getKey() + ". MD5 checksum is " + zipFileMD5);
            putObjectResult = this.s3Client.putObject(putObjectRequest);
        }
        finally {
            jenkinsZipFile.delete();
        }
        return new UploadToS3Output(putObjectRequest.getBucketName() + "/" + putObjectRequest.getKey(), putObjectResult.getVersionId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zipSource(FilePath workspace, String directory, ZipOutputStream out, String prefixToTrim) throws Exception {
        if (!Paths.get(directory, new String[0]).startsWith(Paths.get(prefixToTrim, new String[0]))) {
            throw new Exception("zipSource usage: prefixToTrim must be contained in the given directory.prefixToTrim: " + prefixToTrim + ", directory: " + directory);
        }
        FilePath dir = new FilePath(workspace, directory);
        List dirFiles = dir.list();
        if (dirFiles == null) {
            throw new Exception("Empty or invalid source directory: " + directory + ". Did you download any source as part of your build?");
        }
        byte[] buffer = new byte[1024];
        for (int i = 0; i < dirFiles.size(); ++i) {
            FilePath f = new FilePath(workspace, ((FilePath)dirFiles.get(i)).getRemote());
            if (f.isDirectory()) {
                S3DataManager.zipSource(workspace, f.getRemote() + File.separator, out, prefixToTrim);
                continue;
            }
            try (InputStream inputStream = f.read();){
                int bytesRead;
                String path = S3DataManager.trimPrefix(f.getRemote(), prefixToTrim);
                if (path.startsWith(File.separator)) {
                    path = path.substring(1, path.length());
                }
                path = path.replace(File.separator, "/");
                ZipEntry entry = new ZipEntry(path);
                out.putNextEntry(entry);
                while ((bytesRead = inputStream.read(buffer)) != -1) {
                    out.write(buffer, 0, bytesRead);
                }
                continue;
            }
        }
    }

    public static String trimPrefix(String path, String prefixToTrim) {
        return Paths.get(prefixToTrim, new String[0]).relativize(Paths.get(path, new String[0])).toString();
    }

    @ConstructorProperties(value={"s3Client", "s3InputBucket", "s3InputKey", "sseAlgorithm"})
    public S3DataManager(AmazonS3Client s3Client, String s3InputBucket, String s3InputKey, String sseAlgorithm) {
        this.s3Client = s3Client;
        this.s3InputBucket = s3InputBucket;
        this.s3InputKey = s3InputKey;
        this.sseAlgorithm = sseAlgorithm;
    }
}

