/*
 * Decompiled with CFR 0.152.
 */
import com.amazonaws.services.codebuild.AWSCodeBuildClient;
import com.amazonaws.services.codebuild.model.ArtifactNamespace;
import com.amazonaws.services.codebuild.model.ArtifactPackaging;
import com.amazonaws.services.codebuild.model.ArtifactsType;
import com.amazonaws.services.codebuild.model.BatchGetBuildsRequest;
import com.amazonaws.services.codebuild.model.BatchGetProjectsRequest;
import com.amazonaws.services.codebuild.model.BatchGetProjectsResult;
import com.amazonaws.services.codebuild.model.Build;
import com.amazonaws.services.codebuild.model.BuildArtifacts;
import com.amazonaws.services.codebuild.model.BuildPhaseType;
import com.amazonaws.services.codebuild.model.CacheType;
import com.amazonaws.services.codebuild.model.ComputeType;
import com.amazonaws.services.codebuild.model.EnvironmentType;
import com.amazonaws.services.codebuild.model.EnvironmentVariable;
import com.amazonaws.services.codebuild.model.EnvironmentVariableType;
import com.amazonaws.services.codebuild.model.InvalidInputException;
import com.amazonaws.services.codebuild.model.Project;
import com.amazonaws.services.codebuild.model.ProjectArtifacts;
import com.amazonaws.services.codebuild.model.ProjectCache;
import com.amazonaws.services.codebuild.model.ProjectSource;
import com.amazonaws.services.codebuild.model.SourceAuth;
import com.amazonaws.services.codebuild.model.SourceAuthType;
import com.amazonaws.services.codebuild.model.SourceType;
import com.amazonaws.services.codebuild.model.StartBuildRequest;
import com.amazonaws.services.codebuild.model.StartBuildResult;
import com.amazonaws.services.codebuild.model.StatusType;
import com.amazonaws.services.codebuild.model.StopBuildRequest;
import com.cloudbees.hudson.plugins.folder.Folder;
import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.SystemCredentialsProvider;
import enums.CodeBuildRegions;
import enums.EncryptionAlgorithm;
import enums.SourceControlType;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import jenkins.tasks.SimpleBuildStep;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

public class CodeBuilder
extends Builder
implements SimpleBuildStep {
    private String credentialsType;
    private String credentialsId;
    private String proxyHost;
    private String proxyPort;
    private String awsAccessKey;
    private String awsSecretKey;
    private String awsSessionToken;
    private String region;
    private String projectName;
    private String sourceControlType;
    private String sourceVersion;
    private String sseAlgorithm;
    private String gitCloneDepthOverride;
    private String artifactTypeOverride;
    private String artifactLocationOverride;
    private String artifactNameOverride;
    private String artifactNamespaceOverride;
    private String artifactPackagingOverride;
    private String artifactPathOverride;
    private String environmentTypeOverride;
    private String imageOverride;
    private String computeTypeOverride;
    private String certificateOverride;
    private String cacheTypeOverride;
    private String cacheLocationOverride;
    private String serviceRoleOverride;
    private String privilegedModeOverride;
    private String sourceTypeOverride;
    private String sourceLocationOverride;
    private String insecureSslOverride;
    private String envVariables;
    private String envParameters;
    private String buildSpecFile;
    private String buildTimeoutOverride;
    private final CodeBuildResult codeBuildResult;
    private EnvVars envVars;
    String artifactLocation;
    String artifactType;
    String projectSourceLocation;
    String projectSourceType;
    public static final String authorizationError = "Authorization error";
    public static final String configuredImproperlyError = "CodeBuild configured improperly in project settings";
    public static final String s3BucketBaseURL = "https://console.aws.amazon.com/s3/buckets/";
    public static final String envVariableSyntaxError = "CodeBuild environment variable keys and values cannot be empty and the string must be of the form [{key, value}, {key2, value2}]";
    public static final String envVariableNameSpaceError = "CodeBuild environment variable keys cannot start with CODEBUILD_";
    public static final String invalidProjectError = "Please select a project with S3 source type";
    public static final String notVersionsedS3BucketError = "A versioned S3 bucket is required.\n";
    public static final String httpTimeoutMessage = "Unable to execute HTTP request";
    private static final int MIN_SLEEP_TIME = 2500;
    private static final int MAX_SLEEP_TIME = 60000;
    private static final int SLEEP_JITTER = 5000;
    private int batchGetBuildsCalls;

    @DataBoundConstructor
    public CodeBuilder(String credentialsType, String credentialsId, String proxyHost, String proxyPort, String awsAccessKey, String awsSecretKey, String awsSessionToken, String region, String projectName, String sourceVersion, String sseAlgorithm, String sourceControlType, String gitCloneDepthOverride, String artifactTypeOverride, String artifactLocationOverride, String artifactNameOverride, String artifactNamespaceOverride, String artifactPackagingOverride, String artifactPathOverride, String envVariables, String envParameters, String buildSpecFile, String buildTimeoutOverride, String sourceTypeOverride, String sourceLocationOverride, String environmentTypeOverride, String imageOverride, String computeTypeOverride, String cacheTypeOverride, String cacheLocationOverride, String certificateOverride, String serviceRoleOverride, String insecureSslOverride, String privilegedModeOverride) {
        this.credentialsType = credentialsType;
        this.credentialsId = credentialsId;
        this.proxyHost = proxyHost;
        this.proxyPort = proxyPort;
        this.awsAccessKey = awsAccessKey;
        this.awsSecretKey = awsSecretKey;
        this.awsSessionToken = awsSessionToken;
        this.region = region;
        this.projectName = projectName;
        this.sourceControlType = sourceControlType;
        this.sourceVersion = sourceVersion;
        this.sseAlgorithm = sseAlgorithm;
        this.gitCloneDepthOverride = gitCloneDepthOverride;
        this.artifactTypeOverride = artifactTypeOverride;
        this.artifactLocationOverride = artifactLocationOverride;
        this.artifactNameOverride = artifactNameOverride;
        this.artifactNamespaceOverride = artifactNamespaceOverride;
        this.artifactPackagingOverride = artifactPackagingOverride;
        this.artifactPathOverride = artifactPathOverride;
        this.sourceTypeOverride = sourceTypeOverride;
        this.sourceLocationOverride = sourceLocationOverride;
        this.environmentTypeOverride = environmentTypeOverride;
        this.imageOverride = imageOverride;
        this.computeTypeOverride = computeTypeOverride;
        this.cacheTypeOverride = cacheTypeOverride;
        this.cacheLocationOverride = cacheLocationOverride;
        this.certificateOverride = certificateOverride;
        this.serviceRoleOverride = serviceRoleOverride;
        this.envVariables = envVariables;
        this.envParameters = envParameters;
        this.buildSpecFile = buildSpecFile;
        this.buildTimeoutOverride = buildTimeoutOverride;
        this.insecureSslOverride = insecureSslOverride;
        this.privilegedModeOverride = privilegedModeOverride;
        this.codeBuildResult = new CodeBuildResult();
        this.batchGetBuildsCalls = 0;
    }

    protected Object readResolve() {
        this.credentialsType = Validation.sanitize(this.credentialsType);
        this.credentialsId = Validation.sanitize(this.credentialsId);
        this.proxyHost = Validation.sanitize(this.proxyHost);
        this.proxyPort = Validation.sanitize(this.proxyPort);
        this.awsAccessKey = Validation.sanitize(this.awsAccessKey);
        this.awsSecretKey = Validation.sanitize(this.awsSecretKey);
        this.awsSessionToken = Validation.sanitize(this.awsSessionToken);
        this.region = Validation.sanitize(this.region);
        this.projectName = Validation.sanitize(this.projectName);
        this.sourceControlType = Validation.sanitize(this.sourceControlType);
        this.sourceVersion = Validation.sanitize(this.sourceVersion);
        this.sseAlgorithm = Validation.sanitize(this.sseAlgorithm);
        this.gitCloneDepthOverride = Validation.sanitize(this.gitCloneDepthOverride);
        this.artifactTypeOverride = Validation.sanitize(this.artifactTypeOverride);
        this.artifactLocationOverride = Validation.sanitize(this.artifactLocationOverride);
        this.artifactNameOverride = Validation.sanitize(this.artifactNameOverride);
        this.artifactNamespaceOverride = Validation.sanitize(this.artifactNamespaceOverride);
        this.artifactPackagingOverride = Validation.sanitize(this.artifactPackagingOverride);
        this.artifactPathOverride = Validation.sanitize(this.artifactPathOverride);
        this.sourceTypeOverride = Validation.sanitize(this.sourceTypeOverride);
        this.sourceLocationOverride = Validation.sanitize(this.sourceLocationOverride);
        this.environmentTypeOverride = Validation.sanitize(this.environmentTypeOverride);
        this.imageOverride = Validation.sanitize(this.imageOverride);
        this.computeTypeOverride = Validation.sanitize(this.computeTypeOverride);
        this.cacheTypeOverride = Validation.sanitize(this.cacheTypeOverride);
        this.cacheLocationOverride = Validation.sanitize(this.cacheLocationOverride);
        this.certificateOverride = Validation.sanitize(this.certificateOverride);
        this.serviceRoleOverride = Validation.sanitize(this.serviceRoleOverride);
        this.envVariables = Validation.sanitize(this.envVariables);
        this.envParameters = Validation.sanitize(this.envParameters);
        this.buildSpecFile = Validation.sanitizeYAML(this.buildSpecFile);
        this.buildTimeoutOverride = Validation.sanitize(this.buildTimeoutOverride);
        this.insecureSslOverride = Validation.sanitize(this.insecureSslOverride);
        this.privilegedModeOverride = Validation.sanitize(this.privilegedModeOverride);
        return this;
    }

    public void perform(@Nonnull Run<?, ?> build, @Nonnull FilePath ws, @Nonnull Launcher launcher, @Nonnull TaskListener listener) throws InterruptedException, IOException {
        StartBuildResult sbResult;
        ProjectCache cacheOverride;
        AWSCodeBuildClient cbClient;
        AWSClientFactory awsClientFactory;
        this.envVars = build.getEnvironment(listener);
        try {
            awsClientFactory = new AWSClientFactory(this.getParameterized(this.credentialsType), this.getParameterized(this.credentialsId), this.getParameterized(this.proxyHost), this.getParameterized(this.proxyPort), this.getParameterized(this.awsAccessKey), this.getParameterized(this.awsSecretKey), this.getParameterized(this.awsSessionToken), this.getParameterized(this.region), build);
        }
        catch (Exception e) {
            this.failBuild(build, listener, authorizationError, e.getMessage());
            return;
        }
        String projectConfigError = Validation.checkCodeBuilderConfig(this);
        if (!projectConfigError.isEmpty()) {
            this.failBuild(build, listener, configuredImproperlyError, projectConfigError);
            return;
        }
        String overridesErrorMessage = Validation.checkCodeBuilderStartBuildOverridesConfig(this);
        if (!overridesErrorMessage.isEmpty()) {
            this.failBuild(build, listener, configuredImproperlyError, overridesErrorMessage);
            return;
        }
        Collection<EnvironmentVariable> codeBuildEnvVars = null;
        try {
            codeBuildEnvVars = CodeBuilder.mapEnvVariables(this.getParameterized(this.envVariables), EnvironmentVariableType.PLAINTEXT);
            codeBuildEnvVars.addAll(CodeBuilder.mapEnvVariables(this.getParameterized(this.envParameters), EnvironmentVariableType.PARAMETER_STORE));
        }
        catch (InvalidInputException e) {
            this.failBuild(build, listener, configuredImproperlyError, e.getMessage());
            return;
        }
        if (Validation.envVariablesHaveRestrictedPrefix(codeBuildEnvVars)) {
            this.failBuild(build, listener, configuredImproperlyError, envVariableNameSpaceError);
            return;
        }
        LoggingHelper.log(listener, awsClientFactory.getCredentialsDescriptor());
        try {
            cbClient = awsClientFactory.getCodeBuildClient();
        }
        catch (Exception e) {
            this.failBuild(build, listener, e.getMessage(), "");
            return;
        }
        try {
            this.retrieveArtifactAndSourceInfo(cbClient);
        }
        catch (Exception e) {
            this.failBuild(build, listener, e.getMessage(), "");
            return;
        }
        StartBuildRequest startBuildRequest = new StartBuildRequest().withProjectName(this.getParameterized(this.projectName)).withGitCloneDepthOverride(this.generateStartBuildGitCloneDepthOverride()).withEnvironmentVariablesOverride(codeBuildEnvVars).withBuildspecOverride(this.getParameterized(this.buildSpecFile)).withTimeoutInMinutesOverride(Validation.parseInt(this.getParameterized(this.buildTimeoutOverride)));
        ProjectArtifacts artifactsOverride = this.generateStartBuildArtifactOverride();
        if (artifactsOverride != null) {
            startBuildRequest.setArtifactsOverride(artifactsOverride);
        }
        if ((cacheOverride = this.generateStartBuildCacheOverride()) != null) {
            startBuildRequest.setCacheOverride(cacheOverride);
        }
        if (!this.getParameterized(this.environmentTypeOverride).isEmpty()) {
            startBuildRequest.setEnvironmentTypeOverride(this.getParameterized(this.environmentTypeOverride));
        }
        if (!this.getParameterized(this.imageOverride).isEmpty()) {
            startBuildRequest.setImageOverride(this.getParameterized(this.imageOverride));
        }
        if (!this.getParameterized(this.computeTypeOverride).isEmpty()) {
            startBuildRequest.setComputeTypeOverride(this.getParameterized(this.computeTypeOverride));
        }
        if (!this.getParameterized(this.certificateOverride).isEmpty()) {
            startBuildRequest.setCertificateOverride(this.getParameterized(this.certificateOverride));
        }
        if (!this.getParameterized(this.serviceRoleOverride).isEmpty()) {
            startBuildRequest.setServiceRoleOverride(this.getParameterized(this.serviceRoleOverride));
        }
        if (!this.getParameterized(this.sourceTypeOverride).isEmpty()) {
            startBuildRequest.setSourceTypeOverride(this.getParameterized(this.sourceTypeOverride));
            SourceAuth auth = this.generateStartBuildSourceAuthOverride(this.getParameterized(this.sourceTypeOverride));
            if (auth != null) {
                startBuildRequest.setSourceAuthOverride(auth);
            }
        }
        if (!this.getParameterized(this.sourceLocationOverride).isEmpty()) {
            startBuildRequest.setSourceLocationOverride(this.getParameterized(this.sourceLocationOverride));
        }
        if (!this.getParameterized(this.insecureSslOverride).isEmpty()) {
            startBuildRequest.setInsecureSslOverride(Boolean.valueOf(Boolean.parseBoolean(this.getParameterized(this.insecureSslOverride))));
        }
        if (!this.getParameterized(this.privilegedModeOverride).isEmpty()) {
            startBuildRequest.setPrivilegedModeOverride(Boolean.valueOf(Boolean.parseBoolean(this.getParameterized(this.privilegedModeOverride))));
        }
        if (SourceControlType.JenkinsSource.toString().equals(this.getParameterized(this.sourceControlType))) {
            if (!Validation.checkSourceTypeS3(this.projectSourceType)) {
                this.failBuild(build, listener, invalidProjectError, "");
                return;
            }
            String sourceS3Bucket = Utils.getS3BucketFromObjectArn(this.projectSourceLocation);
            String sourceS3Key = Utils.getS3KeyFromObjectArn(this.projectSourceLocation);
            if (!Validation.checkBucketIsVersioned(sourceS3Bucket, awsClientFactory)) {
                this.failBuild(build, listener, notVersionsedS3BucketError, "");
                return;
            }
            S3DataManager s3DataManager = new S3DataManager(awsClientFactory.getS3Client(), sourceS3Bucket, sourceS3Key, this.getParameterized(this.sseAlgorithm));
            String uploadedSourceVersion = "";
            try {
                UploadToS3Output uploadToS3Output = s3DataManager.uploadSourceToS3(listener, ws);
                if (uploadToS3Output.getObjectVersionId() == null) {
                    this.failBuild(build, listener, notVersionsedS3BucketError, "");
                    return;
                }
                uploadedSourceVersion = uploadToS3Output.getObjectVersionId();
                LoggingHelper.log(listener, "S3 object version id for uploaded source is " + uploadedSourceVersion);
            }
            catch (Exception e) {
                this.failBuild(build, listener, e.getMessage(), "");
                return;
            }
            startBuildRequest.setSourceVersion(uploadedSourceVersion);
            this.logStartBuildMessage(listener, uploadedSourceVersion);
        } else {
            startBuildRequest.setSourceVersion(this.getParameterized(this.sourceVersion));
            this.logStartBuildMessage(listener, this.getParameterized(this.sourceVersion));
        }
        try {
            sbResult = cbClient.startBuild(startBuildRequest);
        }
        catch (Exception e) {
            this.failBuild(build, listener, e.getMessage(), "");
            return;
        }
        Build currentBuild = new Build().withBuildStatus(StatusType.IN_PROGRESS);
        String buildId = sbResult.getBuild().getId();
        LoggingHelper.log(listener, "Build id: " + buildId);
        LoggingHelper.log(listener, "CodeBuild dashboard: " + this.generateDashboardURL(buildId));
        boolean haveInitializedAction = false;
        CodeBuildAction action = null;
        CloudWatchMonitor logMonitor = null;
        do {
            try {
                List buildsForId = cbClient.batchGetBuilds(new BatchGetBuildsRequest().withIds(new String[]{buildId})).getBuilds();
                if (buildsForId.size() != 1) {
                    throw new Exception("Multiple builds mapped to this build id.");
                }
                currentBuild = (Build)buildsForId.get(0);
                if (!haveInitializedAction) {
                    logMonitor = new CloudWatchMonitor(awsClientFactory.getCloudWatchLogsClient());
                    action = new CodeBuildAction(build);
                    String buildARN = currentBuild.getArn();
                    this.codeBuildResult.setBuildInformation(currentBuild.getId(), buildARN);
                    BuildArtifacts artifacts = currentBuild.getArtifacts();
                    this.codeBuildResult.setArtifactsLocation(artifacts != null ? artifacts.getLocation() : null);
                    action.setBuildId(buildId);
                    action.setBuildARN(buildARN);
                    action.setStartTime(currentBuild.getStartTime().toString());
                    ProjectSource source = currentBuild.getSource();
                    if (source != null) {
                        action.setSourceType(source.getType());
                        action.setSourceLocation(source.getLocation());
                        if (currentBuild.getSourceVersion() == null) {
                            action.setSourceVersion("");
                        } else {
                            action.setSourceVersion(currentBuild.getSourceVersion());
                        }
                        Integer depth = source.getGitCloneDepth();
                        if (depth == null || depth == 0) {
                            action.setGitCloneDepth("Full");
                        } else {
                            action.setGitCloneDepth(String.valueOf(depth));
                        }
                    }
                    action.setS3ArtifactURL(this.generateS3ArtifactURL(s3BucketBaseURL, this.artifactLocation, this.artifactType));
                    action.setArtifactTypeOverride(this.getParameterized(this.artifactTypeOverride));
                    action.setCodeBuildDashboardURL(this.generateDashboardURL(buildId));
                    action.setS3BucketName(this.artifactLocation);
                    action.setLogs(new ArrayList<String>());
                    build.addAction((Action)action);
                    haveInitializedAction = true;
                }
                this.updateDashboard(currentBuild, action, logMonitor, listener);
                Thread.sleep(this.getSleepTime());
            }
            catch (Exception e) {
                if (e.getClass().equals(InterruptedException.class)) {
                    List buildsForId = cbClient.batchGetBuilds(new BatchGetBuildsRequest().withIds(new String[]{buildId})).getBuilds();
                    currentBuild = (Build)buildsForId.get(0);
                    if (!currentBuild.getCurrentPhase().equals(BuildPhaseType.COMPLETED.toString())) {
                        cbClient.stopBuild(new StopBuildRequest().withId(buildId));
                        do {
                            buildsForId = cbClient.batchGetBuilds(new BatchGetBuildsRequest().withIds(new String[]{buildId})).getBuilds();
                            currentBuild = (Build)buildsForId.get(0);
                            Thread.sleep(5000L);
                            logMonitor.pollForLogs(listener);
                            this.updateDashboard(currentBuild, action, logMonitor, listener);
                        } while (!currentBuild.getCurrentPhase().equals(BuildPhaseType.COMPLETED.toString()));
                    }
                    if (action != null) {
                        action.setJenkinsBuildSucceeds(false);
                    }
                    this.codeBuildResult.setStopped();
                    build.setResult(Result.ABORTED);
                    return;
                }
                if (e.getMessage().contains(httpTimeoutMessage)) {
                    Thread.sleep(this.getSleepTime());
                    continue;
                }
                if (action != null) {
                    action.setJenkinsBuildSucceeds(false);
                }
                this.failBuild(build, listener, e.getMessage(), "");
                return;
            }
        } while (currentBuild.getBuildStatus().equals(StatusType.IN_PROGRESS.toString()));
        if (currentBuild.getBuildStatus().equals(StatusType.SUCCEEDED.toString().toUpperCase(Locale.ENGLISH))) {
            action.setJenkinsBuildSucceeds(true);
            this.codeBuildResult.setSuccess();
            build.setResult(Result.SUCCESS);
        } else {
            action.setJenkinsBuildSucceeds(false);
            String errorMessage = "Build " + currentBuild.getId() + " failed\n\t> " + action.getPhaseErrorMessage();
            this.failBuild(build, listener, errorMessage, "");
        }
    }

    private int getSleepTime() {
        int sleepTime = 2500 + this.batchGetBuildsCalls++ * 1000 + ThreadLocalRandom.current().nextInt(5000);
        return Math.min(sleepTime, 60000);
    }

    private void retrieveArtifactAndSourceInfo(AWSCodeBuildClient cbClient) throws Exception {
        BatchGetProjectsResult bgpResult = cbClient.batchGetProjects(new BatchGetProjectsRequest().withNames(new String[]{this.getParameterized(this.projectName)}));
        if (bgpResult.getProjects().isEmpty()) {
            throw new RuntimeException("Project " + this.getParameterized(this.projectName) + " does not exist.");
        }
        this.artifactLocation = ((Project)bgpResult.getProjects().get(0)).getArtifacts().getLocation();
        this.artifactType = ((Project)bgpResult.getProjects().get(0)).getArtifacts().getType();
        this.projectSourceLocation = ((Project)bgpResult.getProjects().get(0)).getSource().getLocation();
        this.projectSourceType = ((Project)bgpResult.getProjects().get(0)).getSource().getType();
    }

    private void updateDashboard(Build b, CodeBuildAction action, CloudWatchMonitor logMonitor, TaskListener listener) {
        if (action != null) {
            action.setCurrentStatus(b.getBuildStatus());
            logMonitor.setLogsLocation(b.getLogs());
            logMonitor.pollForLogs(listener);
            action.updateLogs(logMonitor.getLatestLogs());
            action.setPhases(b.getPhases());
            if (logMonitor.getLogsLocation() != null && action.getLogURL() == null) {
                String logUrl = logMonitor.getLogsLocation().getDeepLink();
                action.setLogURL(logUrl);
                LoggingHelper.log(listener, "CloudWatch dashboard: " + logUrl);
            }
        }
    }

    public String generateS3ArtifactURL(String baseURL, String artifactLocation, String artifactType) throws UnsupportedEncodingException {
        if (artifactLocation == null || artifactLocation.isEmpty() || artifactType == null || !artifactType.equals(ArtifactsType.S3.toString())) {
            return "";
        }
        return baseURL + URLEncoder.encode(artifactLocation, "UTF-8");
    }

    private String generateDashboardURL(String buildId) {
        return "https://" + this.getParameterized(this.region) + ".console.aws.amazon.com/codebuild/home?region=" + this.getParameterized(this.region) + "#builds/" + buildId + "/view/new";
    }

    private void logStartBuildMessage(TaskListener listener, String sourceVersion) {
        StringBuilder message = new StringBuilder().append("Starting build with \n\t> project name: " + this.getParameterized(this.projectName));
        if (!this.sourceTypeOverride.isEmpty()) {
            message.append("\n\t> source type: " + this.getParameterized(this.sourceTypeOverride));
        }
        if (!this.sourceLocationOverride.isEmpty()) {
            message.append("\n\t> source location: " + this.getParameterized(this.sourceLocationOverride));
        }
        if (!sourceVersion.isEmpty()) {
            message.append("\n\t> source version: " + sourceVersion);
        }
        if (!SourceControlType.JenkinsSource.toString().equals(this.getParameterized(this.sourceControlType)) && !this.gitCloneDepthOverride.isEmpty()) {
            message.append("\n\t> git clone depth: " + this.getParameterized(this.gitCloneDepthOverride) + " (git clone depth is omitted when source provider is Amazon S3)");
        }
        if (!this.artifactTypeOverride.isEmpty()) {
            message.append("\n\t> artifact type: " + this.getParameterized(this.artifactTypeOverride));
        }
        if (!this.artifactLocationOverride.isEmpty()) {
            message.append("\n\t> artifact location: " + this.getParameterized(this.artifactLocationOverride));
        }
        if (!this.artifactNameOverride.isEmpty()) {
            message.append("\n\t> artifact name: " + this.getParameterized(this.artifactNameOverride));
        }
        if (!this.artifactNamespaceOverride.isEmpty()) {
            message.append("\n\t> artifact namespace: " + this.getParameterized(this.artifactNamespaceOverride));
        }
        if (!this.artifactPackagingOverride.isEmpty()) {
            message.append("\n\t> artifact packaging: " + this.getParameterized(this.artifactPackagingOverride));
        }
        if (!this.artifactPathOverride.isEmpty()) {
            message.append("\n\t> artifact path: " + this.getParameterized(this.artifactPathOverride));
        }
        if (!this.buildSpecFile.isEmpty()) {
            message.append("\n\t> build spec: \n" + this.getParameterized(this.buildSpecFile));
        }
        if (!this.envVariables.isEmpty()) {
            message.append("\n\t> environment variables: " + this.getParameterized(this.envVariables));
        }
        if (!this.buildTimeoutOverride.isEmpty()) {
            message.append("\n\t> build timeout: " + this.getParameterized(this.buildTimeoutOverride));
        }
        if (!this.cacheTypeOverride.isEmpty()) {
            message.append("\n\t> cache type: " + this.getParameterized(this.cacheTypeOverride));
        }
        if (!this.cacheLocationOverride.isEmpty()) {
            message.append("\n\t> cache location: " + this.getParameterized(this.cacheLocationOverride));
        }
        if (!this.environmentTypeOverride.isEmpty()) {
            message.append("\n\t> environment type: " + this.getParameterized(this.environmentTypeOverride));
        }
        if (!this.imageOverride.isEmpty()) {
            message.append("\n\t> image: " + this.getParameterized(this.imageOverride));
        }
        if (!this.privilegedModeOverride.isEmpty()) {
            message.append("\n\t> privileged mode override: " + this.getParameterized(this.privilegedModeOverride));
        }
        if (!this.computeTypeOverride.isEmpty()) {
            message.append("\n\t> compute type: " + this.getParameterized(this.computeTypeOverride));
        }
        if (!this.insecureSslOverride.isEmpty()) {
            message.append("\n\t> insecure ssl override: " + this.getParameterized(this.insecureSslOverride));
        }
        if (!this.certificateOverride.isEmpty()) {
            message.append("\n\t> certificate: " + this.getParameterized(this.certificateOverride));
        }
        if (!this.serviceRoleOverride.isEmpty()) {
            message.append("\n\t> service role: " + this.getParameterized(this.serviceRoleOverride));
        }
        LoggingHelper.log(listener, message.toString());
    }

    private Integer generateStartBuildGitCloneDepthOverride() {
        String depth = this.getParameterized(this.gitCloneDepthOverride);
        if (depth.isEmpty() || depth.equals("Full")) {
            return 0;
        }
        return Integer.parseInt(depth);
    }

    private ProjectArtifacts generateStartBuildArtifactOverride() {
        ProjectArtifacts artifacts = new ProjectArtifacts();
        boolean overridesSpecified = false;
        if (!this.getParameterized(this.artifactTypeOverride).isEmpty()) {
            artifacts.setType(this.getParameterized(this.artifactTypeOverride));
            overridesSpecified = true;
        }
        if (!this.getParameterized(this.artifactLocationOverride).isEmpty()) {
            artifacts.setLocation(this.getParameterized(this.artifactLocationOverride));
            overridesSpecified = true;
        }
        if (!this.getParameterized(this.artifactNameOverride).isEmpty()) {
            artifacts.setName(this.getParameterized(this.artifactNameOverride));
            overridesSpecified = true;
        }
        if (!this.getParameterized(this.artifactNamespaceOverride).isEmpty()) {
            artifacts.setNamespaceType(this.getParameterized(this.artifactNamespaceOverride));
            overridesSpecified = true;
        }
        if (!this.getParameterized(this.artifactPackagingOverride).isEmpty()) {
            artifacts.setPackaging(this.getParameterized(this.artifactPackagingOverride));
            overridesSpecified = true;
        }
        if (!this.getParameterized(this.artifactPathOverride).isEmpty()) {
            artifacts.setPath(this.getParameterized(this.artifactPathOverride));
            overridesSpecified = true;
        }
        return overridesSpecified ? artifacts : null;
    }

    private ProjectCache generateStartBuildCacheOverride() {
        ProjectCache cache = new ProjectCache();
        boolean overridesSpecified = false;
        if (!this.getParameterized(this.cacheTypeOverride).isEmpty()) {
            cache.setType(this.getParameterized(this.cacheTypeOverride));
            overridesSpecified = true;
        }
        if (!this.getParameterized(this.cacheLocationOverride).isEmpty()) {
            cache.setLocation(this.getParameterized(this.cacheLocationOverride));
            overridesSpecified = true;
        }
        return overridesSpecified ? cache : null;
    }

    private SourceAuth generateStartBuildSourceAuthOverride(String sourceType) {
        SourceAuth auth = null;
        if (sourceType.equals(SourceType.GITHUB.toString()) || sourceType.equals(SourceType.BITBUCKET.toString())) {
            auth = new SourceAuth().withType(SourceAuthType.OAUTH.toString());
        }
        return auth;
    }

    public static Collection<EnvironmentVariable> mapEnvVariables(String envVars, EnvironmentVariableType envVarType) throws InvalidInputException {
        HashSet<EnvironmentVariable> result = new HashSet<EnvironmentVariable>();
        if (envVars == null || envVars.isEmpty()) {
            return result;
        }
        envVars = envVars.replaceAll("\\}\\s*,\\s*\\{", "},{");
        envVars = envVars.replaceAll("\\[\\s*\\{", "[{");
        envVars = envVars.replaceAll("\\}\\s*\\]", "}]");
        if ((envVars = envVars.replaceAll("[\\n|\\t]", "").trim()).length() < 4 || envVars.charAt(0) != '[' || envVars.charAt(envVars.length() - 1) != ']' || envVars.charAt(1) != '{' || envVars.charAt(envVars.length() - 2) != '}') {
            throw new InvalidInputException(envVariableSyntaxError);
        }
        int numCommas = (envVars = envVars.substring(2, envVars.length() - 2)).replaceAll("[^,]", "").length();
        if (numCommas == 0) {
            throw new InvalidInputException(envVariableSyntaxError);
        }
        if (numCommas == 1) {
            result.add(CodeBuilder.deserializeCodeBuildEnvVar(envVars, envVarType));
        } else {
            String[] evs = envVars.split("\\},\\{");
            for (int i = 0; i < evs.length; ++i) {
                result.add(CodeBuilder.deserializeCodeBuildEnvVar(evs[i], envVarType));
            }
        }
        return result;
    }

    private static EnvironmentVariable deserializeCodeBuildEnvVar(String ev, EnvironmentVariableType envVarType) throws InvalidInputException {
        if (ev.replaceAll("[^,]", "").length() != 1) {
            throw new InvalidInputException(envVariableSyntaxError);
        }
        String[] keyAndValue = ev.split(",");
        if (keyAndValue.length != 2 || keyAndValue[0].isEmpty() || keyAndValue[1].isEmpty()) {
            throw new InvalidInputException(envVariableSyntaxError);
        }
        return new EnvironmentVariable().withName(keyAndValue[0].trim()).withValue(keyAndValue[1].trim()).withType(envVarType);
    }

    private void failBuild(Run<?, ?> build, TaskListener listener, String errorMessage, String secondaryError) throws AbortException {
        this.codeBuildResult.setFailure(errorMessage, secondaryError);
        build.setResult(Result.FAILURE);
        LoggingHelper.log(listener, errorMessage, secondaryError);
    }

    public String getParameterized(String codeBuildParam) {
        String result = this.envVars.expand(codeBuildParam);
        if (result == null) {
            return "";
        }
        return result;
    }

    public String sourceControlTypeEquals(String given) {
        return String.valueOf(this.sourceControlType != null && this.sourceControlType.equals(given));
    }

    public String credentialsTypeEquals(String given) {
        return String.valueOf(this.credentialsType != null && this.credentialsType.equals(given));
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    public String getCredentialsType() {
        return this.credentialsType;
    }

    public String getCredentialsId() {
        return this.credentialsId;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public String getProxyPort() {
        return this.proxyPort;
    }

    public String getAwsAccessKey() {
        return this.awsAccessKey;
    }

    public String getAwsSecretKey() {
        return this.awsSecretKey;
    }

    public String getAwsSessionToken() {
        return this.awsSessionToken;
    }

    public String getRegion() {
        return this.region;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public String getSourceControlType() {
        return this.sourceControlType;
    }

    public String getSourceVersion() {
        return this.sourceVersion;
    }

    public String getSseAlgorithm() {
        return this.sseAlgorithm;
    }

    public String getGitCloneDepthOverride() {
        return this.gitCloneDepthOverride;
    }

    public String getArtifactTypeOverride() {
        return this.artifactTypeOverride;
    }

    public String getArtifactLocationOverride() {
        return this.artifactLocationOverride;
    }

    public String getArtifactNameOverride() {
        return this.artifactNameOverride;
    }

    public String getArtifactNamespaceOverride() {
        return this.artifactNamespaceOverride;
    }

    public String getArtifactPackagingOverride() {
        return this.artifactPackagingOverride;
    }

    public String getArtifactPathOverride() {
        return this.artifactPathOverride;
    }

    public String getEnvironmentTypeOverride() {
        return this.environmentTypeOverride;
    }

    public String getImageOverride() {
        return this.imageOverride;
    }

    public String getComputeTypeOverride() {
        return this.computeTypeOverride;
    }

    public String getCertificateOverride() {
        return this.certificateOverride;
    }

    public String getCacheTypeOverride() {
        return this.cacheTypeOverride;
    }

    public String getCacheLocationOverride() {
        return this.cacheLocationOverride;
    }

    public String getServiceRoleOverride() {
        return this.serviceRoleOverride;
    }

    public String getPrivilegedModeOverride() {
        return this.privilegedModeOverride;
    }

    public String getSourceTypeOverride() {
        return this.sourceTypeOverride;
    }

    public String getSourceLocationOverride() {
        return this.sourceLocationOverride;
    }

    public String getInsecureSslOverride() {
        return this.insecureSslOverride;
    }

    public String getEnvVariables() {
        return this.envVariables;
    }

    public String getEnvParameters() {
        return this.envParameters;
    }

    public String getBuildSpecFile() {
        return this.buildSpecFile;
    }

    public String getBuildTimeoutOverride() {
        return this.buildTimeoutOverride;
    }

    public CodeBuildResult getCodeBuildResult() {
        return this.codeBuildResult;
    }

    public String getArtifactLocation() {
        return this.artifactLocation;
    }

    public void setArtifactLocation(String artifactLocation) {
        this.artifactLocation = artifactLocation;
    }

    public String getArtifactType() {
        return this.artifactType;
    }

    public void setArtifactType(String artifactType) {
        this.artifactType = artifactType;
    }

    public String getProjectSourceLocation() {
        return this.projectSourceLocation;
    }

    public void setProjectSourceLocation(String projectSourceLocation) {
        this.projectSourceLocation = projectSourceLocation;
    }

    public String getProjectSourceType() {
        return this.projectSourceType;
    }

    public void setProjectSourceType(String projectSourceType) {
        this.projectSourceType = projectSourceType;
    }

    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        public DescriptorImpl() {
            this.load();
        }

        public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            req.bindJSON((Object)this, formData);
            this.save();
            return super.configure(req, formData);
        }

        public ListBoxModel doFillGitCloneDepthOverrideItems() {
            ListBoxModel selections = new ListBoxModel();
            selections.add("1");
            selections.add("5");
            selections.add("25");
            selections.add("Full");
            selections.add("");
            return selections;
        }

        public ListBoxModel doFillPrivilegedModeOverrideItems() {
            ListBoxModel selections = new ListBoxModel();
            selections.add("False");
            selections.add("True");
            selections.add("");
            return selections;
        }

        public ListBoxModel doFillInsecureSslOverrideItems() {
            ListBoxModel selections = new ListBoxModel();
            selections.add("False");
            selections.add("True");
            selections.add("");
            return selections;
        }

        public ListBoxModel doFillArtifactTypeOverrideItems() {
            ListBoxModel selections = new ListBoxModel();
            for (ArtifactsType t : ArtifactsType.values()) {
                selections.add(t.toString());
            }
            selections.add("");
            return selections;
        }

        public ListBoxModel doFillArtifactNamespaceOverrideItems() {
            ListBoxModel selections = new ListBoxModel();
            for (ArtifactNamespace t : ArtifactNamespace.values()) {
                selections.add(t.toString());
            }
            selections.add("");
            return selections;
        }

        public ListBoxModel doFillArtifactPackagingOverrideItems() {
            ListBoxModel selections = new ListBoxModel();
            for (ArtifactPackaging t : ArtifactPackaging.values()) {
                selections.add(t.toString());
            }
            selections.add("");
            return selections;
        }

        public ListBoxModel doFillSourceTypeOverrideItems() {
            ListBoxModel selections = new ListBoxModel();
            for (SourceType t : SourceType.values()) {
                if (t.equals((Object)SourceType.CODEPIPELINE)) continue;
                selections.add(t.toString());
            }
            selections.add("");
            return selections;
        }

        public ListBoxModel doFillComputeTypeOverrideItems() {
            ListBoxModel selections = new ListBoxModel();
            for (ComputeType t : ComputeType.values()) {
                selections.add(t.toString());
            }
            selections.add("");
            return selections;
        }

        public ListBoxModel doFillCacheTypeOverrideItems() {
            ListBoxModel selections = new ListBoxModel();
            for (CacheType t : CacheType.values()) {
                selections.add(t.toString());
            }
            selections.add("");
            return selections;
        }

        public ListBoxModel doFillEnvironmentTypeOverrideItems() {
            ListBoxModel selections = new ListBoxModel();
            for (EnvironmentType t : EnvironmentType.values()) {
                selections.add(t.toString());
            }
            selections.add("");
            return selections;
        }

        public ListBoxModel doFillRegionItems() {
            ListBoxModel selections = new ListBoxModel();
            for (CodeBuildRegions r : CodeBuildRegions.values()) {
                selections.add(r.toString());
            }
            return selections;
        }

        public ListBoxModel doFillCredentialsIdItems() {
            ListBoxModel selections = new ListBoxModel();
            SystemCredentialsProvider s = SystemCredentialsProvider.getInstance();
            HashSet<String> displayCredentials = new HashSet<String>();
            for (Credentials c : s.getCredentials()) {
                if (!(c instanceof CodeBuildCredentials)) continue;
                displayCredentials.add(((CodeBuildCredentials)c).getId());
            }
            Jenkins instance = Jenkins.getInstance();
            if (instance != null) {
                List folders = instance.getAllItems(Folder.class);
                for (Folder folder : folders) {
                    List creds = CredentialsProvider.lookupCredentials(Credentials.class, (Item)folder);
                    for (Credentials cred : creds) {
                        if (!(cred instanceof CodeBuildCredentials)) continue;
                        displayCredentials.add(((CodeBuildCredentials)cred).getId());
                    }
                }
            }
            for (String credString : displayCredentials) {
                selections.add(credString);
            }
            return selections;
        }

        public ListBoxModel doFillSseAlgorithmItems() {
            ListBoxModel selections = new ListBoxModel();
            for (EncryptionAlgorithm e : EncryptionAlgorithm.values()) {
                selections.add(e.toString());
            }
            return selections;
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public String getDisplayName() {
            return "AWS CodeBuild";
        }
    }
}

