/*
 * Decompiled with CFR 0.152.
 */
import com.amazonaws.services.codebuild.model.BuildPhase;
import com.amazonaws.services.codebuild.model.PhaseContext;
import com.amazonaws.services.codebuild.model.StatusType;
import hudson.model.Action;
import hudson.model.Run;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class CodeBuildAction
implements Action {
    private final Run<?, ?> build;
    private String buildId;
    private List<String> logs;
    private String logURL;
    private List<BuildPhase> phases;
    private String phaseErrorMessage;
    private String startTime;
    private String currentPhase;
    private String currentStatus;
    private String environmentARN;
    private String buildARN;
    private String sourceType;
    private String sourceLocation;
    private String sourceVersion;
    private String gitCloneDepth;
    private String s3BucketName;
    private String s3ArtifactURL;
    private String artifactTypeOverride;
    private String codeBuildDashboardURL;
    private Boolean jenkinsBuildSucceeds;
    private static final int MAX_DASHBOARD_NAME_LENGTH = 15;

    public String getIconFileName() {
        return "star-gold.png";
    }

    public String getDisplayName() {
        return "CodeBuild: " + Utils.formatStringWithEllipsis(this.getBuildId(), 15);
    }

    public String getUrlName() {
        String id = this.getBuildId();
        return id.substring(id.indexOf(":") + 1, id.length());
    }

    private void formatLatestPhase() {
        if (this.phases != null && !this.phases.isEmpty()) {
            BuildPhase latest = this.phases.get(this.phases.size() - 1);
            if (latest.getPhaseStatus() == null) {
                if (latest.getPhaseType().equals("COMPLETED")) {
                    latest.setPhaseStatus(StatusType.SUCCEEDED.toString().toUpperCase(Locale.ENGLISH));
                } else {
                    latest.setPhaseStatus("IN PROGRESS");
                }
            }
            latest.setDurationInSeconds(Long.valueOf(0L));
        }
    }

    public List<BuildPhase> getPhases() {
        this.formatLatestPhase();
        return this.phases;
    }

    public String getJenkinsBuildSucceeds() {
        if (this.jenkinsBuildSucceeds == null) {
            return "";
        }
        return this.jenkinsBuildSucceeds.toString();
    }

    public String getFinishTime() {
        if (this.getCurrentBuildPhase().getPhaseType().equals("COMPLETED")) {
            return this.getCurrentBuildPhase().getStartTime().toString();
        }
        return "-";
    }

    public String getCurrentPhase() {
        return this.getCurrentBuildPhase().getPhaseType();
    }

    private BuildPhase getCurrentBuildPhase() {
        if (this.phases == null || this.phases.isEmpty()) {
            return new BuildPhase().withPhaseType("-");
        }
        return this.phases.get(this.phases.size() - 1);
    }

    public String getPhaseErrorMessage() {
        BuildPhase errorPhase = this.getErrorPhase();
        if (errorPhase == null) {
            return "";
        }
        if (!errorPhase.getContexts().isEmpty()) {
            return ((PhaseContext)errorPhase.getContexts().get(0)).getMessage().replace("'", "").replace("\n", "") + " (status code: " + ((PhaseContext)errorPhase.getContexts().get(0)).getStatusCode() + ")";
        }
        return "";
    }

    public String getErrorPhaseType() {
        BuildPhase errorPhase = this.getErrorPhase();
        if (errorPhase == null) {
            return "";
        }
        return errorPhase.getPhaseType();
    }

    private BuildPhase getErrorPhase() {
        if (this.phases != null) {
            for (BuildPhase p : this.phases) {
                String status = p.getPhaseStatus();
                if (status == null || !status.equals(StatusType.FAULT.toString().toUpperCase(Locale.ENGLISH)) && !status.equals("CLIENT_ERROR") && !status.equals(StatusType.FAILED.toString().toUpperCase(Locale.ENGLISH))) continue;
                return p;
            }
        }
        return null;
    }

    public String getBuildStatus() {
        if (this.currentStatus != null && this.currentStatus.equals(StatusType.IN_PROGRESS.toString())) {
            return "IN PROGRESS";
        }
        return this.currentStatus;
    }

    public void updateLogs(List<String> newLogs) {
        if (this.logs != null) {
            if (this.logs.size() == 1 && this.logs.get(0).equals("No CloudWatch logs found for this build.")) {
                if (newLogs.size() > 0 && !newLogs.get(0).equals("No CloudWatch logs found for this build.")) {
                    this.logs = new ArrayList<String>();
                } else {
                    return;
                }
            }
            this.logs.addAll(newLogs);
        }
    }

    @ConstructorProperties(value={"build"})
    public CodeBuildAction(Run<?, ?> build) {
        this.build = build;
    }

    public Run<?, ?> getBuild() {
        return this.build;
    }

    public String getBuildId() {
        return this.buildId;
    }

    public List<String> getLogs() {
        return this.logs;
    }

    public String getLogURL() {
        return this.logURL;
    }

    public String getStartTime() {
        return this.startTime;
    }

    public String getCurrentStatus() {
        return this.currentStatus;
    }

    public String getEnvironmentARN() {
        return this.environmentARN;
    }

    public String getBuildARN() {
        return this.buildARN;
    }

    public String getSourceType() {
        return this.sourceType;
    }

    public String getSourceLocation() {
        return this.sourceLocation;
    }

    public String getSourceVersion() {
        return this.sourceVersion;
    }

    public String getGitCloneDepth() {
        return this.gitCloneDepth;
    }

    public String getS3BucketName() {
        return this.s3BucketName;
    }

    public String getS3ArtifactURL() {
        return this.s3ArtifactURL;
    }

    public String getArtifactTypeOverride() {
        return this.artifactTypeOverride;
    }

    public String getCodeBuildDashboardURL() {
        return this.codeBuildDashboardURL;
    }

    public void setBuildId(String buildId) {
        this.buildId = buildId;
    }

    public void setLogs(List<String> logs) {
        this.logs = logs;
    }

    public void setLogURL(String logURL) {
        this.logURL = logURL;
    }

    public void setPhases(List<BuildPhase> phases) {
        this.phases = phases;
    }

    public void setPhaseErrorMessage(String phaseErrorMessage) {
        this.phaseErrorMessage = phaseErrorMessage;
    }

    public void setStartTime(String startTime) {
        this.startTime = startTime;
    }

    public void setCurrentPhase(String currentPhase) {
        this.currentPhase = currentPhase;
    }

    public void setCurrentStatus(String currentStatus) {
        this.currentStatus = currentStatus;
    }

    public void setEnvironmentARN(String environmentARN) {
        this.environmentARN = environmentARN;
    }

    public void setBuildARN(String buildARN) {
        this.buildARN = buildARN;
    }

    public void setSourceType(String sourceType) {
        this.sourceType = sourceType;
    }

    public void setSourceLocation(String sourceLocation) {
        this.sourceLocation = sourceLocation;
    }

    public void setSourceVersion(String sourceVersion) {
        this.sourceVersion = sourceVersion;
    }

    public void setGitCloneDepth(String gitCloneDepth) {
        this.gitCloneDepth = gitCloneDepth;
    }

    public void setS3BucketName(String s3BucketName) {
        this.s3BucketName = s3BucketName;
    }

    public void setS3ArtifactURL(String s3ArtifactURL) {
        this.s3ArtifactURL = s3ArtifactURL;
    }

    public void setArtifactTypeOverride(String artifactTypeOverride) {
        this.artifactTypeOverride = artifactTypeOverride;
    }

    public void setCodeBuildDashboardURL(String codeBuildDashboardURL) {
        this.codeBuildDashboardURL = codeBuildDashboardURL;
    }

    public void setJenkinsBuildSucceeds(Boolean jenkinsBuildSucceeds) {
        this.jenkinsBuildSucceeds = jenkinsBuildSucceeds;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CodeBuildAction)) {
            return false;
        }
        CodeBuildAction other = (CodeBuildAction)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Run<?, ?> this$build = this.getBuild();
        Run<?, ?> other$build = other.getBuild();
        if (this$build == null ? other$build != null : !this$build.equals(other$build)) {
            return false;
        }
        String this$buildId = this.getBuildId();
        String other$buildId = other.getBuildId();
        if (this$buildId == null ? other$buildId != null : !this$buildId.equals(other$buildId)) {
            return false;
        }
        List<String> this$logs = this.getLogs();
        List<String> other$logs = other.getLogs();
        if (this$logs == null ? other$logs != null : !((Object)this$logs).equals(other$logs)) {
            return false;
        }
        String this$logURL = this.getLogURL();
        String other$logURL = other.getLogURL();
        if (this$logURL == null ? other$logURL != null : !this$logURL.equals(other$logURL)) {
            return false;
        }
        List<BuildPhase> this$phases = this.getPhases();
        List<BuildPhase> other$phases = other.getPhases();
        if (this$phases == null ? other$phases != null : !((Object)this$phases).equals(other$phases)) {
            return false;
        }
        String this$phaseErrorMessage = this.getPhaseErrorMessage();
        String other$phaseErrorMessage = other.getPhaseErrorMessage();
        if (this$phaseErrorMessage == null ? other$phaseErrorMessage != null : !this$phaseErrorMessage.equals(other$phaseErrorMessage)) {
            return false;
        }
        String this$startTime = this.getStartTime();
        String other$startTime = other.getStartTime();
        if (this$startTime == null ? other$startTime != null : !this$startTime.equals(other$startTime)) {
            return false;
        }
        String this$currentPhase = this.getCurrentPhase();
        String other$currentPhase = other.getCurrentPhase();
        if (this$currentPhase == null ? other$currentPhase != null : !this$currentPhase.equals(other$currentPhase)) {
            return false;
        }
        String this$currentStatus = this.getCurrentStatus();
        String other$currentStatus = other.getCurrentStatus();
        if (this$currentStatus == null ? other$currentStatus != null : !this$currentStatus.equals(other$currentStatus)) {
            return false;
        }
        String this$environmentARN = this.getEnvironmentARN();
        String other$environmentARN = other.getEnvironmentARN();
        if (this$environmentARN == null ? other$environmentARN != null : !this$environmentARN.equals(other$environmentARN)) {
            return false;
        }
        String this$buildARN = this.getBuildARN();
        String other$buildARN = other.getBuildARN();
        if (this$buildARN == null ? other$buildARN != null : !this$buildARN.equals(other$buildARN)) {
            return false;
        }
        String this$sourceType = this.getSourceType();
        String other$sourceType = other.getSourceType();
        if (this$sourceType == null ? other$sourceType != null : !this$sourceType.equals(other$sourceType)) {
            return false;
        }
        String this$sourceLocation = this.getSourceLocation();
        String other$sourceLocation = other.getSourceLocation();
        if (this$sourceLocation == null ? other$sourceLocation != null : !this$sourceLocation.equals(other$sourceLocation)) {
            return false;
        }
        String this$sourceVersion = this.getSourceVersion();
        String other$sourceVersion = other.getSourceVersion();
        if (this$sourceVersion == null ? other$sourceVersion != null : !this$sourceVersion.equals(other$sourceVersion)) {
            return false;
        }
        String this$gitCloneDepth = this.getGitCloneDepth();
        String other$gitCloneDepth = other.getGitCloneDepth();
        if (this$gitCloneDepth == null ? other$gitCloneDepth != null : !this$gitCloneDepth.equals(other$gitCloneDepth)) {
            return false;
        }
        String this$s3BucketName = this.getS3BucketName();
        String other$s3BucketName = other.getS3BucketName();
        if (this$s3BucketName == null ? other$s3BucketName != null : !this$s3BucketName.equals(other$s3BucketName)) {
            return false;
        }
        String this$s3ArtifactURL = this.getS3ArtifactURL();
        String other$s3ArtifactURL = other.getS3ArtifactURL();
        if (this$s3ArtifactURL == null ? other$s3ArtifactURL != null : !this$s3ArtifactURL.equals(other$s3ArtifactURL)) {
            return false;
        }
        String this$artifactTypeOverride = this.getArtifactTypeOverride();
        String other$artifactTypeOverride = other.getArtifactTypeOverride();
        if (this$artifactTypeOverride == null ? other$artifactTypeOverride != null : !this$artifactTypeOverride.equals(other$artifactTypeOverride)) {
            return false;
        }
        String this$codeBuildDashboardURL = this.getCodeBuildDashboardURL();
        String other$codeBuildDashboardURL = other.getCodeBuildDashboardURL();
        if (this$codeBuildDashboardURL == null ? other$codeBuildDashboardURL != null : !this$codeBuildDashboardURL.equals(other$codeBuildDashboardURL)) {
            return false;
        }
        String this$jenkinsBuildSucceeds = this.getJenkinsBuildSucceeds();
        String other$jenkinsBuildSucceeds = other.getJenkinsBuildSucceeds();
        return !(this$jenkinsBuildSucceeds == null ? other$jenkinsBuildSucceeds != null : !this$jenkinsBuildSucceeds.equals(other$jenkinsBuildSucceeds));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CodeBuildAction;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Run<?, ?> $build = this.getBuild();
        result = result * 59 + ($build == null ? 43 : $build.hashCode());
        String $buildId = this.getBuildId();
        result = result * 59 + ($buildId == null ? 43 : $buildId.hashCode());
        List<String> $logs = this.getLogs();
        result = result * 59 + ($logs == null ? 43 : ((Object)$logs).hashCode());
        String $logURL = this.getLogURL();
        result = result * 59 + ($logURL == null ? 43 : $logURL.hashCode());
        List<BuildPhase> $phases = this.getPhases();
        result = result * 59 + ($phases == null ? 43 : ((Object)$phases).hashCode());
        String $phaseErrorMessage = this.getPhaseErrorMessage();
        result = result * 59 + ($phaseErrorMessage == null ? 43 : $phaseErrorMessage.hashCode());
        String $startTime = this.getStartTime();
        result = result * 59 + ($startTime == null ? 43 : $startTime.hashCode());
        String $currentPhase = this.getCurrentPhase();
        result = result * 59 + ($currentPhase == null ? 43 : $currentPhase.hashCode());
        String $currentStatus = this.getCurrentStatus();
        result = result * 59 + ($currentStatus == null ? 43 : $currentStatus.hashCode());
        String $environmentARN = this.getEnvironmentARN();
        result = result * 59 + ($environmentARN == null ? 43 : $environmentARN.hashCode());
        String $buildARN = this.getBuildARN();
        result = result * 59 + ($buildARN == null ? 43 : $buildARN.hashCode());
        String $sourceType = this.getSourceType();
        result = result * 59 + ($sourceType == null ? 43 : $sourceType.hashCode());
        String $sourceLocation = this.getSourceLocation();
        result = result * 59 + ($sourceLocation == null ? 43 : $sourceLocation.hashCode());
        String $sourceVersion = this.getSourceVersion();
        result = result * 59 + ($sourceVersion == null ? 43 : $sourceVersion.hashCode());
        String $gitCloneDepth = this.getGitCloneDepth();
        result = result * 59 + ($gitCloneDepth == null ? 43 : $gitCloneDepth.hashCode());
        String $s3BucketName = this.getS3BucketName();
        result = result * 59 + ($s3BucketName == null ? 43 : $s3BucketName.hashCode());
        String $s3ArtifactURL = this.getS3ArtifactURL();
        result = result * 59 + ($s3ArtifactURL == null ? 43 : $s3ArtifactURL.hashCode());
        String $artifactTypeOverride = this.getArtifactTypeOverride();
        result = result * 59 + ($artifactTypeOverride == null ? 43 : $artifactTypeOverride.hashCode());
        String $codeBuildDashboardURL = this.getCodeBuildDashboardURL();
        result = result * 59 + ($codeBuildDashboardURL == null ? 43 : $codeBuildDashboardURL.hashCode());
        String $jenkinsBuildSucceeds = this.getJenkinsBuildSucceeds();
        result = result * 59 + ($jenkinsBuildSucceeds == null ? 43 : $jenkinsBuildSucceeds.hashCode());
        return result;
    }

    public String toString() {
        return "CodeBuildAction(build=" + this.getBuild() + ", buildId=" + this.getBuildId() + ", logs=" + this.getLogs() + ", logURL=" + this.getLogURL() + ", phases=" + this.getPhases() + ", phaseErrorMessage=" + this.getPhaseErrorMessage() + ", startTime=" + this.getStartTime() + ", currentPhase=" + this.getCurrentPhase() + ", currentStatus=" + this.getCurrentStatus() + ", environmentARN=" + this.getEnvironmentARN() + ", buildARN=" + this.getBuildARN() + ", sourceType=" + this.getSourceType() + ", sourceLocation=" + this.getSourceLocation() + ", sourceVersion=" + this.getSourceVersion() + ", gitCloneDepth=" + this.getGitCloneDepth() + ", s3BucketName=" + this.getS3BucketName() + ", s3ArtifactURL=" + this.getS3ArtifactURL() + ", artifactTypeOverride=" + this.getArtifactTypeOverride() + ", codeBuildDashboardURL=" + this.getCodeBuildDashboardURL() + ", jenkinsBuildSucceeds=" + this.getJenkinsBuildSucceeds() + ")";
    }
}

