/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.s3.transferutility;

import android.database.Cursor;
import com.amazonaws.AmazonClientException;
import com.amazonaws.logging.Log;
import com.amazonaws.logging.LogFactory;
import com.amazonaws.mobileconnectors.s3.transferutility.DownloadTask;
import com.amazonaws.mobileconnectors.s3.transferutility.TransferDBUtil;
import com.amazonaws.mobileconnectors.s3.transferutility.TransferService;
import com.amazonaws.mobileconnectors.s3.transferutility.TransferState;
import com.amazonaws.mobileconnectors.s3.transferutility.TransferStatusUpdater;
import com.amazonaws.mobileconnectors.s3.transferutility.TransferThreadPool;
import com.amazonaws.mobileconnectors.s3.transferutility.TransferType;
import com.amazonaws.mobileconnectors.s3.transferutility.UploadTask;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.AbortMultipartUploadRequest;
import com.amazonaws.util.json.JsonUtils;
import java.io.File;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

class TransferRecord {
    private static final Log LOGGER = LogFactory.getLog(TransferRecord.class);
    public int id;
    public int mainUploadId;
    public int isRequesterPays;
    public int isMultipart;
    public int isLastPart;
    public int isEncrypted;
    public int partNumber;
    public long bytesTotal;
    public long bytesCurrent;
    public long speed;
    public long rangeStart;
    public long rangeLast;
    public long fileOffset;
    public TransferType type;
    public TransferState state;
    public String bucketName;
    public String key;
    public String versionId;
    public String file;
    public String multipartId;
    public String eTag;
    public String headerContentType;
    public String headerContentLanguage;
    public String headerContentDisposition;
    public String headerContentEncoding;
    public String headerCacheControl;
    public String headerExpire;
    public String headerStorageClass;
    public Map<String, String> userMetadata;
    public String expirationTimeRuleId;
    public String httpExpires;
    public String sseAlgorithm;
    public String sseKMSKey;
    public String md5;
    public String cannedAcl;
    private Future<?> submittedTask;

    public TransferRecord(int id) {
        this.id = id;
    }

    public void updateFromDB(Cursor c) {
        this.id = c.getInt(c.getColumnIndexOrThrow("_id"));
        this.mainUploadId = c.getInt(c.getColumnIndexOrThrow("main_upload_id"));
        this.type = TransferType.getType(c.getString(c.getColumnIndexOrThrow("type")));
        this.state = TransferState.getState(c.getString(c.getColumnIndexOrThrow("state")));
        this.bucketName = c.getString(c.getColumnIndexOrThrow("bucket_name"));
        this.key = c.getString(c.getColumnIndexOrThrow("key"));
        this.versionId = c.getString(c.getColumnIndexOrThrow("version_id"));
        this.bytesTotal = c.getLong(c.getColumnIndexOrThrow("bytes_total"));
        this.bytesCurrent = c.getLong(c.getColumnIndexOrThrow("bytes_current"));
        this.speed = c.getLong(c.getColumnIndexOrThrow("speed"));
        this.isRequesterPays = c.getInt(c.getColumnIndexOrThrow("is_requester_pays"));
        this.isMultipart = c.getInt(c.getColumnIndexOrThrow("is_multipart"));
        this.isLastPart = c.getInt(c.getColumnIndexOrThrow("is_last_part"));
        this.isEncrypted = c.getInt(c.getColumnIndexOrThrow("is_encrypted"));
        this.partNumber = c.getInt(c.getColumnIndexOrThrow("part_num"));
        this.eTag = c.getString(c.getColumnIndexOrThrow("etag"));
        this.file = c.getString(c.getColumnIndexOrThrow("file"));
        this.multipartId = c.getString(c.getColumnIndexOrThrow("multipart_id"));
        this.rangeStart = c.getLong(c.getColumnIndexOrThrow("range_start"));
        this.rangeLast = c.getLong(c.getColumnIndexOrThrow("range_last"));
        this.fileOffset = c.getLong(c.getColumnIndexOrThrow("file_offset"));
        this.headerContentType = c.getString(c.getColumnIndexOrThrow("header_content_type"));
        this.headerContentLanguage = c.getString(c.getColumnIndexOrThrow("header_content_language"));
        this.headerContentDisposition = c.getString(c.getColumnIndexOrThrow("header_content_disposition"));
        this.headerContentEncoding = c.getString(c.getColumnIndexOrThrow("header_content_encoding"));
        this.headerCacheControl = c.getString(c.getColumnIndexOrThrow("header_cache_control"));
        this.headerExpire = c.getString(c.getColumnIndexOrThrow("header_expire"));
        this.userMetadata = JsonUtils.jsonToMap((String)c.getString(c.getColumnIndexOrThrow("user_metadata")));
        this.expirationTimeRuleId = c.getString(c.getColumnIndexOrThrow("expiration_time_rule_id"));
        this.httpExpires = c.getString(c.getColumnIndexOrThrow("http_expires_date"));
        this.sseAlgorithm = c.getString(c.getColumnIndexOrThrow("sse_algorithm"));
        this.sseKMSKey = c.getString(c.getColumnIndexOrThrow("kms_key"));
        this.md5 = c.getString(c.getColumnIndexOrThrow("content_md5"));
        this.cannedAcl = c.getString(c.getColumnIndexOrThrow("canned_acl"));
        this.headerStorageClass = c.getString(c.getColumnIndexOrThrow("header_storage_class"));
    }

    public boolean start(AmazonS3 s3, TransferDBUtil dbUtil, TransferStatusUpdater updater, TransferService.NetworkInfoReceiver networkInfo) {
        if (!this.isRunning() && this.checkIsReadyToRun()) {
            this.submittedTask = this.type.equals((Object)TransferType.DOWNLOAD) ? TransferThreadPool.submitTask(new DownloadTask(this, s3, updater, networkInfo)) : TransferThreadPool.submitTask(new UploadTask(this, s3, dbUtil, updater, networkInfo));
            return true;
        }
        return false;
    }

    public boolean pause(AmazonS3 s3, TransferStatusUpdater updater) {
        if (!this.isFinalState(this.state) && !TransferState.PAUSED.equals((Object)this.state)) {
            updater.updateState(this.id, TransferState.PAUSED);
            if (this.isRunning()) {
                this.submittedTask.cancel(true);
            }
            return true;
        }
        return false;
    }

    public boolean cancel(final AmazonS3 s3, TransferStatusUpdater updater) {
        if (!this.isFinalState(this.state)) {
            updater.updateState(this.id, TransferState.CANCELED);
            if (this.isRunning()) {
                this.submittedTask.cancel(true);
            }
            if (this.isMultipart == 1) {
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            s3.abortMultipartUpload(new AbortMultipartUploadRequest(TransferRecord.this.bucketName, TransferRecord.this.key, TransferRecord.this.multipartId));
                            LOGGER.debug((Object)("Successfully clean up multipart upload: " + TransferRecord.this.id));
                        }
                        catch (AmazonClientException e) {
                            LOGGER.debug((Object)("Failed to abort multiplart upload: " + TransferRecord.this.id), (Throwable)e);
                        }
                    }
                }).start();
            } else if (TransferType.DOWNLOAD.equals((Object)this.type)) {
                new File(this.file).delete();
            }
            return true;
        }
        return false;
    }

    boolean isRunning() {
        return this.submittedTask != null && !this.submittedTask.isDone();
    }

    void waitTillFinish(long timeout) throws InterruptedException, ExecutionException, TimeoutException {
        if (this.isRunning()) {
            this.submittedTask.get(timeout, TimeUnit.MILLISECONDS);
        }
    }

    private boolean isFinalState(TransferState state) {
        return TransferState.COMPLETED.equals((Object)state) || TransferState.FAILED.equals((Object)state) || TransferState.CANCELED.equals((Object)state);
    }

    private boolean checkIsReadyToRun() {
        return this.partNumber == 0 && !TransferState.COMPLETED.equals((Object)this.state);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[").append("id:").append(this.id).append(",").append("bucketName:").append(this.bucketName).append(",").append("key:").append(this.key).append(",").append("file:").append(this.file).append(",").append("type:").append((Object)this.type).append(",").append("bytesTotal:").append(this.bytesTotal).append(",").append("bytesCurrent:").append(this.bytesCurrent).append(",").append("fileOffset:").append(this.fileOffset).append(",").append("state:").append((Object)this.state).append(",").append("cannedAcl:").append(this.cannedAcl).append(",").append("mainUploadId:").append(this.mainUploadId).append(",").append("isMultipart:").append(this.isMultipart).append(",").append("isLastPart:").append(this.isLastPart).append(",").append("partNumber:").append(this.partNumber).append(",").append("multipartId:").append(this.multipartId).append(",").append("eTag:").append(this.eTag).append(",").append("storageClass:").append(this.headerStorageClass).append(",").append("userMetadata:").append(this.userMetadata.toString()).append(",").append("]");
        return sb.toString();
    }
}

