/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.s3.transferutility;

import android.os.Handler;
import android.os.Looper;
import com.amazonaws.event.ProgressEvent;
import com.amazonaws.event.ProgressListener;
import com.amazonaws.mobileconnectors.s3.transferutility.S3ClientReference;
import com.amazonaws.mobileconnectors.s3.transferutility.TransferDBUtil;
import com.amazonaws.mobileconnectors.s3.transferutility.TransferListener;
import com.amazonaws.mobileconnectors.s3.transferutility.TransferRecord;
import com.amazonaws.mobileconnectors.s3.transferutility.TransferState;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class TransferStatusUpdater {
    private static final Log LOGGER = LogFactory.getLog(TransferStatusUpdater.class);
    private static final HashSet<TransferState> STATES_NOT_TO_NOTIFY = new HashSet<TransferState>(Arrays.asList(TransferState.PART_COMPLETED, TransferState.PENDING_CANCEL, TransferState.PENDING_PAUSE, TransferState.PENDING_NETWORK_DISCONNECT));
    private static final int UPDATE_THRESHOLD_MS = 1000;
    static final Map<Integer, List<TransferListener>> LISTENERS = new HashMap<Integer, List<TransferListener>>();
    private final Map<Integer, TransferRecord> transfers;
    private final Map<Integer, Long> lastUpdateTime;
    private final TransferDBUtil dbUtil;
    private final Handler mainHandler;

    TransferStatusUpdater(TransferDBUtil dbUtil) {
        this.dbUtil = dbUtil;
        this.mainHandler = new Handler(Looper.getMainLooper());
        this.transfers = new HashMap<Integer, TransferRecord>();
        this.lastUpdateTime = new HashMap<Integer, Long>();
    }

    Map<Integer, TransferRecord> getTransfers() {
        return Collections.unmodifiableMap(this.transfers);
    }

    void addTransfer(TransferRecord transfer) {
        this.transfers.put(transfer.id, transfer);
    }

    TransferRecord getTransfer(int id) {
        return this.transfers.get(id);
    }

    void removeTransfer(int id) {
        this.transfers.remove(id);
        LISTENERS.remove(id);
        this.lastUpdateTime.remove(id);
    }

    void removeTransferRecordFromDB(int id) {
        S3ClientReference.remove(id);
        this.dbUtil.deleteTransferRecords(id);
    }

    void updateState(final int id, final TransferState newState) {
        boolean shouldNotNotify = STATES_NOT_TO_NOTIFY.contains((Object)newState);
        TransferRecord transfer = this.transfers.get(id);
        if (transfer == null) {
            if (this.dbUtil.updateState(id, newState) == 0) {
                LOGGER.warn((Object)("Failed to update the status of transfer " + id));
            }
        } else {
            shouldNotNotify |= newState.equals((Object)transfer.state);
            transfer.state = newState;
            if (this.dbUtil.updateTransferRecord(transfer) == 0) {
                LOGGER.warn((Object)("Failed to update the status of transfer " + id));
            }
        }
        if (shouldNotNotify) {
            return;
        }
        final List<TransferListener> list = LISTENERS.get(id);
        if (list == null || list.isEmpty()) {
            if (TransferState.COMPLETED.equals((Object)newState)) {
                this.removeTransferRecordFromDB(id);
            }
            return;
        }
        this.mainHandler.post(new Runnable(){

            @Override
            public void run() {
                for (TransferListener l : list) {
                    l.onStateChanged(id, newState);
                }
                if (TransferState.COMPLETED.equals((Object)newState) || TransferState.FAILED.equals((Object)newState) || TransferState.CANCELED.equals((Object)newState)) {
                    list.clear();
                }
                if (TransferState.COMPLETED.equals((Object)newState)) {
                    TransferStatusUpdater.this.removeTransferRecordFromDB(id);
                }
            }
        });
    }

    void updateProgress(final int id, final long bytesCurrent, final long bytesTotal) {
        TransferRecord transfer = this.transfers.get(id);
        if (transfer != null) {
            transfer.bytesCurrent = bytesCurrent;
            transfer.bytesTotal = bytesTotal;
        }
        long timeInMillis = System.currentTimeMillis();
        this.dbUtil.updateBytesTransferred(id, bytesCurrent);
        final List<TransferListener> list = LISTENERS.get(id);
        if (list == null || list.isEmpty()) {
            return;
        }
        if (!this.lastUpdateTime.containsKey(id) || timeInMillis - this.lastUpdateTime.get(id) > 1000L || bytesCurrent == bytesTotal) {
            this.lastUpdateTime.put(id, timeInMillis);
            this.mainHandler.post(new Runnable(){

                @Override
                public void run() {
                    for (TransferListener l : list) {
                        l.onProgressChanged(id, bytesCurrent, bytesTotal);
                    }
                }
            });
        }
    }

    void throwError(final int id, final Exception e) {
        final List<TransferListener> list = LISTENERS.get(id);
        if (list == null || list.isEmpty()) {
            return;
        }
        this.mainHandler.post(new Runnable(){

            @Override
            public void run() {
                for (TransferListener l : list) {
                    l.onError(id, e);
                }
            }
        });
    }

    void clear() {
        LISTENERS.clear();
        this.transfers.clear();
        this.lastUpdateTime.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void registerListener(int id, TransferListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Listener can't be null");
        }
        Map<Integer, List<TransferListener>> map = LISTENERS;
        synchronized (map) {
            List<TransferListener> list = LISTENERS.get(id);
            if (list == null) {
                list = new CopyOnWriteArrayList<TransferListener>();
                list.add(listener);
                LISTENERS.put(id, list);
            } else if (!list.contains(listener)) {
                list.add(listener);
            }
        }
    }

    static void unregisterListener(int id, TransferListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Listener can't be null");
        }
        List<TransferListener> list = LISTENERS.get(id);
        if (list == null || list.isEmpty()) {
            return;
        }
        list.remove(listener);
    }

    ProgressListener newProgressListener(int id) {
        TransferRecord transfer = this.getTransfer(id);
        if (transfer == null) {
            throw new IllegalArgumentException("transfer " + id + " doesn't exist");
        }
        return new TransferProgressListener(transfer);
    }

    private class TransferProgressListener
    implements ProgressListener {
        private final TransferRecord transfer;
        private long bytesCurrent;

        public TransferProgressListener(TransferRecord transfer) {
            this.transfer = transfer;
        }

        public synchronized void progressChanged(ProgressEvent progressEvent) {
            if (progressEvent.getEventCode() == 32) {
                this.transfer.bytesCurrent -= this.bytesCurrent;
                this.bytesCurrent = 0L;
            } else {
                this.bytesCurrent += progressEvent.getBytesTransferred();
                this.transfer.bytesCurrent += progressEvent.getBytesTransferred();
            }
            TransferStatusUpdater.this.updateProgress(this.transfer.id, this.transfer.bytesCurrent, this.transfer.bytesTotal);
        }
    }
}

