/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.internal.crypto;

import com.amazonaws.services.s3.internal.crypto.ContentCryptoScheme;

class AesCtr
extends ContentCryptoScheme {
    private static final int DEFAULT_IV_LENGTH_IN_BYTES = 16;
    private static final int SUPPORTED_IV_LENGTH = 12;

    AesCtr() {
    }

    @Override
    String getKeyGeneratorAlgorithm() {
        return AES_GCM.getKeyGeneratorAlgorithm();
    }

    @Override
    String getCipherAlgorithm() {
        return "AES/CTR/NoPadding";
    }

    @Override
    int getKeyLengthInBits() {
        return AES_GCM.getKeyLengthInBits();
    }

    @Override
    int getBlockSizeInBytes() {
        return AES_GCM.getBlockSizeInBytes();
    }

    @Override
    int getIVLengthInBytes() {
        return 16;
    }

    @Override
    long getMaxPlaintextSize() {
        return -1L;
    }

    @Override
    byte[] adjustIV(byte[] iv, long byteOffset) {
        if (iv.length != 12) {
            throw new UnsupportedOperationException();
        }
        int blockSize = this.getBlockSizeInBytes();
        long blockOffset = byteOffset / (long)blockSize;
        if (blockOffset * (long)blockSize != byteOffset) {
            throw new IllegalArgumentException("Expecting byteOffset to be multiple of 16, but got blockOffset=" + blockOffset + ", blockSize=" + blockSize + ", byteOffset=" + byteOffset);
        }
        byte[] j0 = this.computeJ0(iv);
        return AesCtr.incrementBlocks(j0, blockOffset);
    }

    private byte[] computeJ0(byte[] nonce) {
        int blockSize = this.getBlockSizeInBytes();
        byte[] j0 = new byte[blockSize];
        System.arraycopy(nonce, 0, j0, 0, nonce.length);
        j0[blockSize - 1] = 1;
        return AesCtr.incrementBlocks(j0, 1L);
    }
}

