/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.internal.crypto;

import com.amazonaws.logging.Log;
import com.amazonaws.logging.LogFactory;
import com.amazonaws.services.s3.internal.crypto.ContentCryptoScheme;
import java.security.Provider;
import java.security.Security;
import javax.crypto.Cipher;

@Deprecated
public class CryptoRuntime {
    static final String BOUNCY_CASTLE_PROVIDER = "BC";
    private static final String BC_PROVIDER_FQCN = "org.bouncycastle.jce.provider.BouncyCastleProvider";
    private static final Log LOGGER = LogFactory.getLog(CryptoRuntime.class);

    public static synchronized boolean isBouncyCastleAvailable() {
        return Security.getProvider(BOUNCY_CASTLE_PROVIDER) != null;
    }

    public static synchronized void enableBouncyCastle() {
        if (CryptoRuntime.isBouncyCastleAvailable()) {
            return;
        }
        try {
            Class<?> c = Class.forName(BC_PROVIDER_FQCN);
            Provider provider = (Provider)c.newInstance();
            Security.addProvider(provider);
        }
        catch (Exception e) {
            LOGGER.debug((Object)"Bouncy Castle not available", (Throwable)e);
        }
    }

    public static boolean isAesGcmAvailable(Provider cryptoProvider) {
        return AesGcm.check(cryptoProvider != null ? cryptoProvider : Security.getProvider(BOUNCY_CASTLE_PROVIDER));
    }

    static boolean isRsaKeyWrapAvailable(Provider cryptoProvider) {
        return RsaEcbOaepWithSHA256AndMGF1Padding.check(cryptoProvider != null ? cryptoProvider : Security.getProvider(BOUNCY_CASTLE_PROVIDER));
    }

    private static final class RsaEcbOaepWithSHA256AndMGF1Padding {
        private RsaEcbOaepWithSHA256AndMGF1Padding() {
        }

        private static boolean check(Provider cryptoProvider) {
            try {
                Cipher.getInstance("RSA/ECB/OAEPWithSHA-256AndMGF1Padding", cryptoProvider);
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }
    }

    private static final class AesGcm {
        private AesGcm() {
        }

        private static boolean check(Provider cryptoProvider) {
            try {
                Cipher.getInstance(ContentCryptoScheme.AES_GCM.getCipherAlgorithm(), cryptoProvider);
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }
    }
}

