/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobile.client;

import android.content.ComponentName;
import android.content.Context;
import android.net.Uri;
import android.support.customtabs.CustomTabsCallback;
import android.support.customtabs.CustomTabsClient;
import android.support.customtabs.CustomTabsIntent;
import android.support.customtabs.CustomTabsServiceConnection;
import android.support.customtabs.CustomTabsSession;
import com.amazonaws.mobileconnectors.cognitoauth.util.Pkce;
import java.util.Map;

class OAuth2Utils {
    private final Context mContext;
    private final Uri mSignInRedirectUri;
    private CustomTabsServiceConnection mCustomTabsServiceConnection;
    private CustomTabsClient mCustomTabsClient;
    private CustomTabsSession mCustomTabsSession;
    private CustomTabsCallback customTabsCallback;
    private String mState;
    private String mError;
    private String mErrorDescription;

    OAuth2Utils(Context context, Uri signInRedirectUri) {
        this.mContext = context;
        this.mSignInRedirectUri = signInRedirectUri;
        this.customTabsCallback = new CustomTabsCallback();
    }

    void preWarm() {
        this.mCustomTabsServiceConnection = new CustomTabsServiceConnection(){

            public void onCustomTabsServiceConnected(ComponentName name, CustomTabsClient client) {
                OAuth2Utils.this.mCustomTabsClient = client;
                OAuth2Utils.this.mCustomTabsClient.warmup(0L);
                OAuth2Utils.this.mCustomTabsSession = OAuth2Utils.this.mCustomTabsClient.newSession(OAuth2Utils.this.customTabsCallback);
            }

            public void onServiceDisconnected(ComponentName name) {
                OAuth2Utils.this.mCustomTabsClient = null;
            }
        };
        CustomTabsClient.bindCustomTabsService((Context)this.mContext, (String)"com.android.chrome", (CustomTabsServiceConnection)this.mCustomTabsServiceConnection);
    }

    void authorize(String webDomain, String clientId, Map<String, String> queryParameterMap) {
        this.mState = Pkce.generateRandom();
        Uri.Builder builder = Uri.parse((String)webDomain).buildUpon();
        for (Map.Entry<String, String> entry : queryParameterMap.entrySet()) {
            builder.appendQueryParameter(entry.getKey(), entry.getValue());
        }
        if (!queryParameterMap.containsKey("code")) {
            builder.appendQueryParameter("response_type", "code");
        }
        if (!queryParameterMap.containsKey("client_id")) {
            if (clientId != null) {
                builder.appendQueryParameter("client_id", clientId);
            } else {
                throw new IllegalArgumentException("Client id must be specified for an authorization request.");
            }
        }
        builder.appendQueryParameter("state", this.mState);
        this.navigate(builder.build());
    }

    void navigate(Uri uri) {
        CustomTabsIntent.Builder builder = new CustomTabsIntent.Builder(this.mCustomTabsSession);
        CustomTabsIntent mCustomTabsIntent = builder.build();
        mCustomTabsIntent.intent.setPackage("com.android.chrome");
        mCustomTabsIntent.intent.addFlags(0x40000000);
        mCustomTabsIntent.intent.addFlags(0x10000000);
        mCustomTabsIntent.launchUrl(this.mContext, uri);
    }

    boolean parse(Uri uri) {
        if (uri.getScheme().equals(this.mSignInRedirectUri.getScheme()) && uri.getAuthority().equals(this.mSignInRedirectUri.getAuthority()) && uri.getPath().equals(this.mSignInRedirectUri.getPath()) && uri.getQueryParameterNames().containsAll(this.mSignInRedirectUri.getQueryParameterNames())) {
            String code = uri.getQueryParameter("code");
            String state = uri.getQueryParameter("state");
            if (!this.mState.equals(state)) {
                return false;
            }
            this.mError = uri.getQueryParameter("error");
            this.mErrorDescription = uri.getQueryParameter("error_description");
            if (this.mError != null) {
                return true;
            }
        }
        return false;
    }

    Uri exchangeCode(String uri) {
        return null;
    }
}

