/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobile.client.internal.oauth2;

import com.amazonaws.internal.keyvaluestore.AWSKeyValueStore;
import com.amazonaws.mobile.client.internal.oauth2.OAuth2Client;
import com.amazonaws.mobile.client.internal.oauth2.OAuth2Constants;
import com.amazonaws.mobile.client.internal.oauth2.OAuth2Tokens;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

class OAuth2ClientStore {
    private final AWSKeyValueStore mKeyValueStore;
    ReadWriteLock mReadWriteLock = new ReentrantReadWriteLock();

    OAuth2ClientStore(OAuth2Client client) {
        this.mKeyValueStore = new AWSKeyValueStore(client.mContext, "com.amazonaws.mobile.client.oauth2", client.mIsPersistenceEnabled);
    }

    void set(OAuth2Tokens tokens) {
        try {
            this.mReadWriteLock.writeLock().lock();
            this.mKeyValueStore.put(OAuth2Constants.TokenResponseFields.ACCESS_TOKEN.toString(), tokens.getAccessToken());
            this.mKeyValueStore.put(OAuth2Constants.TokenResponseFields.ID_TOKEN.toString(), tokens.getIdToken());
            this.mKeyValueStore.put(OAuth2Constants.TokenResponseFields.REFRESH_TOKEN.toString(), tokens.getRefreshToken());
            this.mKeyValueStore.put(OAuth2Constants.TokenResponseFields.EXPIRES_IN.toString(), tokens.getExpiresIn() == null ? null : tokens.getExpiresIn().toString());
            this.mKeyValueStore.put("createDate", tokens.getCreateDate().toString());
        }
        finally {
            this.mReadWriteLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    OAuth2Tokens getTokens() {
        try {
            this.mReadWriteLock.readLock().lock();
            String expires_in = this.mKeyValueStore.get(OAuth2Constants.TokenResponseFields.EXPIRES_IN.toString());
            Long expiresIn = expires_in == null ? null : Long.decode(expires_in);
            OAuth2Tokens oAuth2Tokens = new OAuth2Tokens(this.mKeyValueStore.get(OAuth2Constants.TokenResponseFields.ACCESS_TOKEN.toString()), this.mKeyValueStore.get(OAuth2Constants.TokenResponseFields.ID_TOKEN.toString()), this.mKeyValueStore.get(OAuth2Constants.TokenResponseFields.REFRESH_TOKEN.toString()), this.mKeyValueStore.get(OAuth2Constants.TokenResponseFields.TOKEN_TYPE.toString()), expiresIn, Long.valueOf(this.mKeyValueStore.get("createDate")), this.mKeyValueStore.get(OAuth2Constants.TokenResponseFields.SCOPES.toString()));
            return oAuth2Tokens;
        }
        finally {
            this.mReadWriteLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map<String, String> get(String ... keys) {
        try {
            this.mReadWriteLock.readLock().lock();
            HashMap<String, String> attributes = new HashMap<String, String>();
            for (String key : keys) {
                attributes.put(key, this.mKeyValueStore.get(key));
            }
            HashMap<String, String> hashMap = attributes;
            return hashMap;
        }
        finally {
            this.mReadWriteLock.readLock().unlock();
        }
    }

    String get(String key) {
        try {
            this.mReadWriteLock.readLock().lock();
            String string = this.mKeyValueStore.get(key);
            return string;
        }
        finally {
            this.mReadWriteLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void set(Map<String, String> attributes) {
        try {
            this.mReadWriteLock.writeLock().lock();
            for (String key : attributes.keySet()) {
                this.mKeyValueStore.put(key, attributes.get(key));
            }
        }
        finally {
            this.mReadWriteLock.writeLock().unlock();
        }
    }

    void set(String key, String value) {
        try {
            this.mReadWriteLock.writeLock().lock();
            this.mKeyValueStore.put(key, value);
        }
        finally {
            this.mReadWriteLock.writeLock().unlock();
        }
    }

    void clear() {
        this.mKeyValueStore.clear();
    }

    public void setPersistenceEnabled(boolean isPersistenceEnabled) {
        this.mKeyValueStore.setPersistenceEnabled(isPersistenceEnabled);
    }
}

