/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kms.model;

import com.amazonaws.services.kms.model.KeyEncryptionMechanism;
import java.io.Serializable;
import java.nio.ByteBuffer;

public class RecipientInfo
implements Serializable {
    private String keyEncryptionAlgorithm;
    private ByteBuffer attestationDocument;

    public String getKeyEncryptionAlgorithm() {
        return this.keyEncryptionAlgorithm;
    }

    public void setKeyEncryptionAlgorithm(String keyEncryptionAlgorithm) {
        this.keyEncryptionAlgorithm = keyEncryptionAlgorithm;
    }

    public RecipientInfo withKeyEncryptionAlgorithm(String keyEncryptionAlgorithm) {
        this.keyEncryptionAlgorithm = keyEncryptionAlgorithm;
        return this;
    }

    public void setKeyEncryptionAlgorithm(KeyEncryptionMechanism keyEncryptionAlgorithm) {
        this.keyEncryptionAlgorithm = keyEncryptionAlgorithm.toString();
    }

    public RecipientInfo withKeyEncryptionAlgorithm(KeyEncryptionMechanism keyEncryptionAlgorithm) {
        this.keyEncryptionAlgorithm = keyEncryptionAlgorithm.toString();
        return this;
    }

    public ByteBuffer getAttestationDocument() {
        return this.attestationDocument;
    }

    public void setAttestationDocument(ByteBuffer attestationDocument) {
        this.attestationDocument = attestationDocument;
    }

    public RecipientInfo withAttestationDocument(ByteBuffer attestationDocument) {
        this.attestationDocument = attestationDocument;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getKeyEncryptionAlgorithm() != null) {
            sb.append("KeyEncryptionAlgorithm: " + this.getKeyEncryptionAlgorithm() + ",");
        }
        if (this.getAttestationDocument() != null) {
            sb.append("AttestationDocument: " + this.getAttestationDocument());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getKeyEncryptionAlgorithm() == null ? 0 : this.getKeyEncryptionAlgorithm().hashCode());
        hashCode = 31 * hashCode + (this.getAttestationDocument() == null ? 0 : this.getAttestationDocument().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecipientInfo)) {
            return false;
        }
        RecipientInfo other = (RecipientInfo)obj;
        if (other.getKeyEncryptionAlgorithm() == null ^ this.getKeyEncryptionAlgorithm() == null) {
            return false;
        }
        if (other.getKeyEncryptionAlgorithm() != null && !other.getKeyEncryptionAlgorithm().equals(this.getKeyEncryptionAlgorithm())) {
            return false;
        }
        if (other.getAttestationDocument() == null ^ this.getAttestationDocument() == null) {
            return false;
        }
        return other.getAttestationDocument() == null || other.getAttestationDocument().equals(this.getAttestationDocument());
    }
}

