/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kms.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.kms.model.DataKeyPairSpec;
import com.amazonaws.services.kms.model.RecipientInfo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GenerateDataKeyPairRequest
extends AmazonWebServiceRequest
implements Serializable {
    private Map<String, String> encryptionContext = new HashMap<String, String>();
    private String keyId;
    private String keyPairSpec;
    private List<String> grantTokens = new ArrayList<String>();
    private RecipientInfo recipient;
    private Boolean dryRun;

    public Map<String, String> getEncryptionContext() {
        return this.encryptionContext;
    }

    public void setEncryptionContext(Map<String, String> encryptionContext) {
        this.encryptionContext = encryptionContext;
    }

    public GenerateDataKeyPairRequest withEncryptionContext(Map<String, String> encryptionContext) {
        this.encryptionContext = encryptionContext;
        return this;
    }

    public GenerateDataKeyPairRequest addEncryptionContextEntry(String key, String value) {
        if (null == this.encryptionContext) {
            this.encryptionContext = new HashMap<String, String>();
        }
        if (this.encryptionContext.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.encryptionContext.put(key, value);
        return this;
    }

    public GenerateDataKeyPairRequest clearEncryptionContextEntries() {
        this.encryptionContext = null;
        return this;
    }

    public String getKeyId() {
        return this.keyId;
    }

    public void setKeyId(String keyId) {
        this.keyId = keyId;
    }

    public GenerateDataKeyPairRequest withKeyId(String keyId) {
        this.keyId = keyId;
        return this;
    }

    public String getKeyPairSpec() {
        return this.keyPairSpec;
    }

    public void setKeyPairSpec(String keyPairSpec) {
        this.keyPairSpec = keyPairSpec;
    }

    public GenerateDataKeyPairRequest withKeyPairSpec(String keyPairSpec) {
        this.keyPairSpec = keyPairSpec;
        return this;
    }

    public void setKeyPairSpec(DataKeyPairSpec keyPairSpec) {
        this.keyPairSpec = keyPairSpec.toString();
    }

    public GenerateDataKeyPairRequest withKeyPairSpec(DataKeyPairSpec keyPairSpec) {
        this.keyPairSpec = keyPairSpec.toString();
        return this;
    }

    public List<String> getGrantTokens() {
        return this.grantTokens;
    }

    public void setGrantTokens(Collection<String> grantTokens) {
        if (grantTokens == null) {
            this.grantTokens = null;
            return;
        }
        this.grantTokens = new ArrayList<String>(grantTokens);
    }

    public GenerateDataKeyPairRequest withGrantTokens(String ... grantTokens) {
        if (this.getGrantTokens() == null) {
            this.grantTokens = new ArrayList<String>(grantTokens.length);
        }
        for (String value : grantTokens) {
            this.grantTokens.add(value);
        }
        return this;
    }

    public GenerateDataKeyPairRequest withGrantTokens(Collection<String> grantTokens) {
        this.setGrantTokens(grantTokens);
        return this;
    }

    public RecipientInfo getRecipient() {
        return this.recipient;
    }

    public void setRecipient(RecipientInfo recipient) {
        this.recipient = recipient;
    }

    public GenerateDataKeyPairRequest withRecipient(RecipientInfo recipient) {
        this.recipient = recipient;
        return this;
    }

    public Boolean isDryRun() {
        return this.dryRun;
    }

    public Boolean getDryRun() {
        return this.dryRun;
    }

    public void setDryRun(Boolean dryRun) {
        this.dryRun = dryRun;
    }

    public GenerateDataKeyPairRequest withDryRun(Boolean dryRun) {
        this.dryRun = dryRun;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getEncryptionContext() != null) {
            sb.append("EncryptionContext: " + this.getEncryptionContext() + ",");
        }
        if (this.getKeyId() != null) {
            sb.append("KeyId: " + this.getKeyId() + ",");
        }
        if (this.getKeyPairSpec() != null) {
            sb.append("KeyPairSpec: " + this.getKeyPairSpec() + ",");
        }
        if (this.getGrantTokens() != null) {
            sb.append("GrantTokens: " + this.getGrantTokens() + ",");
        }
        if (this.getRecipient() != null) {
            sb.append("Recipient: " + this.getRecipient() + ",");
        }
        if (this.getDryRun() != null) {
            sb.append("DryRun: " + this.getDryRun());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getEncryptionContext() == null ? 0 : this.getEncryptionContext().hashCode());
        hashCode = 31 * hashCode + (this.getKeyId() == null ? 0 : this.getKeyId().hashCode());
        hashCode = 31 * hashCode + (this.getKeyPairSpec() == null ? 0 : this.getKeyPairSpec().hashCode());
        hashCode = 31 * hashCode + (this.getGrantTokens() == null ? 0 : this.getGrantTokens().hashCode());
        hashCode = 31 * hashCode + (this.getRecipient() == null ? 0 : this.getRecipient().hashCode());
        hashCode = 31 * hashCode + (this.getDryRun() == null ? 0 : this.getDryRun().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GenerateDataKeyPairRequest)) {
            return false;
        }
        GenerateDataKeyPairRequest other = (GenerateDataKeyPairRequest)obj;
        if (other.getEncryptionContext() == null ^ this.getEncryptionContext() == null) {
            return false;
        }
        if (other.getEncryptionContext() != null && !other.getEncryptionContext().equals(this.getEncryptionContext())) {
            return false;
        }
        if (other.getKeyId() == null ^ this.getKeyId() == null) {
            return false;
        }
        if (other.getKeyId() != null && !other.getKeyId().equals(this.getKeyId())) {
            return false;
        }
        if (other.getKeyPairSpec() == null ^ this.getKeyPairSpec() == null) {
            return false;
        }
        if (other.getKeyPairSpec() != null && !other.getKeyPairSpec().equals(this.getKeyPairSpec())) {
            return false;
        }
        if (other.getGrantTokens() == null ^ this.getGrantTokens() == null) {
            return false;
        }
        if (other.getGrantTokens() != null && !other.getGrantTokens().equals(this.getGrantTokens())) {
            return false;
        }
        if (other.getRecipient() == null ^ this.getRecipient() == null) {
            return false;
        }
        if (other.getRecipient() != null && !other.getRecipient().equals(this.getRecipient())) {
            return false;
        }
        if (other.getDryRun() == null ^ this.getDryRun() == null) {
            return false;
        }
        return other.getDryRun() == null || other.getDryRun().equals(this.getDryRun());
    }
}

