/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kms.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.kms.model.ReEncryptRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.AwsJsonWriter;
import com.amazonaws.util.json.JsonUtils;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;

public class ReEncryptRequestMarshaller
implements Marshaller<Request<ReEncryptRequest>, ReEncryptRequest> {
    public Request<ReEncryptRequest> marshall(ReEncryptRequest reEncryptRequest) {
        if (reEncryptRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(ReEncryptRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)reEncryptRequest, "AWSKMS");
        String target = "TrentService.ReEncrypt";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/";
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = new StringWriter();
            AwsJsonWriter jsonWriter = JsonUtils.getJsonWriter((Writer)stringWriter);
            jsonWriter.beginObject();
            if (reEncryptRequest.getCiphertextBlob() != null) {
                ByteBuffer ciphertextBlob = reEncryptRequest.getCiphertextBlob();
                jsonWriter.name("CiphertextBlob");
                jsonWriter.value(ciphertextBlob);
            }
            if (reEncryptRequest.getSourceEncryptionContext() != null) {
                Map<String, String> sourceEncryptionContext = reEncryptRequest.getSourceEncryptionContext();
                jsonWriter.name("SourceEncryptionContext");
                jsonWriter.beginObject();
                for (Map.Entry<String, String> sourceEncryptionContextEntry : sourceEncryptionContext.entrySet()) {
                    String sourceEncryptionContextValue = sourceEncryptionContextEntry.getValue();
                    if (sourceEncryptionContextValue == null) continue;
                    jsonWriter.name(sourceEncryptionContextEntry.getKey());
                    jsonWriter.value(sourceEncryptionContextValue);
                }
                jsonWriter.endObject();
            }
            if (reEncryptRequest.getSourceKeyId() != null) {
                String sourceKeyId = reEncryptRequest.getSourceKeyId();
                jsonWriter.name("SourceKeyId");
                jsonWriter.value(sourceKeyId);
            }
            if (reEncryptRequest.getDestinationKeyId() != null) {
                String destinationKeyId = reEncryptRequest.getDestinationKeyId();
                jsonWriter.name("DestinationKeyId");
                jsonWriter.value(destinationKeyId);
            }
            if (reEncryptRequest.getDestinationEncryptionContext() != null) {
                Map<String, String> destinationEncryptionContext = reEncryptRequest.getDestinationEncryptionContext();
                jsonWriter.name("DestinationEncryptionContext");
                jsonWriter.beginObject();
                for (Map.Entry<String, String> destinationEncryptionContextEntry : destinationEncryptionContext.entrySet()) {
                    String destinationEncryptionContextValue = destinationEncryptionContextEntry.getValue();
                    if (destinationEncryptionContextValue == null) continue;
                    jsonWriter.name(destinationEncryptionContextEntry.getKey());
                    jsonWriter.value(destinationEncryptionContextValue);
                }
                jsonWriter.endObject();
            }
            if (reEncryptRequest.getSourceEncryptionAlgorithm() != null) {
                String sourceEncryptionAlgorithm = reEncryptRequest.getSourceEncryptionAlgorithm();
                jsonWriter.name("SourceEncryptionAlgorithm");
                jsonWriter.value(sourceEncryptionAlgorithm);
            }
            if (reEncryptRequest.getDestinationEncryptionAlgorithm() != null) {
                String destinationEncryptionAlgorithm = reEncryptRequest.getDestinationEncryptionAlgorithm();
                jsonWriter.name("DestinationEncryptionAlgorithm");
                jsonWriter.value(destinationEncryptionAlgorithm);
            }
            if (reEncryptRequest.getGrantTokens() != null) {
                List<String> grantTokens = reEncryptRequest.getGrantTokens();
                jsonWriter.name("GrantTokens");
                jsonWriter.beginArray();
                for (String grantTokensItem : grantTokens) {
                    if (grantTokensItem == null) continue;
                    jsonWriter.value(grantTokensItem);
                }
                jsonWriter.endArray();
            }
            if (reEncryptRequest.getDryRun() != null) {
                Boolean dryRun = reEncryptRequest.getDryRun();
                jsonWriter.name("DryRun");
                jsonWriter.value(dryRun.booleanValue());
            }
            jsonWriter.endObject();
            jsonWriter.close();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        return request;
    }
}

