/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kms.model;

import com.amazonaws.services.kms.model.MacAlgorithmSpec;
import java.io.Serializable;
import java.nio.ByteBuffer;

public class GenerateMacResult
implements Serializable {
    private ByteBuffer mac;
    private String macAlgorithm;
    private String keyId;

    public ByteBuffer getMac() {
        return this.mac;
    }

    public void setMac(ByteBuffer mac) {
        this.mac = mac;
    }

    public GenerateMacResult withMac(ByteBuffer mac) {
        this.mac = mac;
        return this;
    }

    public String getMacAlgorithm() {
        return this.macAlgorithm;
    }

    public void setMacAlgorithm(String macAlgorithm) {
        this.macAlgorithm = macAlgorithm;
    }

    public GenerateMacResult withMacAlgorithm(String macAlgorithm) {
        this.macAlgorithm = macAlgorithm;
        return this;
    }

    public void setMacAlgorithm(MacAlgorithmSpec macAlgorithm) {
        this.macAlgorithm = macAlgorithm.toString();
    }

    public GenerateMacResult withMacAlgorithm(MacAlgorithmSpec macAlgorithm) {
        this.macAlgorithm = macAlgorithm.toString();
        return this;
    }

    public String getKeyId() {
        return this.keyId;
    }

    public void setKeyId(String keyId) {
        this.keyId = keyId;
    }

    public GenerateMacResult withKeyId(String keyId) {
        this.keyId = keyId;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getMac() != null) {
            sb.append("Mac: " + this.getMac() + ",");
        }
        if (this.getMacAlgorithm() != null) {
            sb.append("MacAlgorithm: " + this.getMacAlgorithm() + ",");
        }
        if (this.getKeyId() != null) {
            sb.append("KeyId: " + this.getKeyId());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getMac() == null ? 0 : this.getMac().hashCode());
        hashCode = 31 * hashCode + (this.getMacAlgorithm() == null ? 0 : this.getMacAlgorithm().hashCode());
        hashCode = 31 * hashCode + (this.getKeyId() == null ? 0 : this.getKeyId().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GenerateMacResult)) {
            return false;
        }
        GenerateMacResult other = (GenerateMacResult)obj;
        if (other.getMac() == null ^ this.getMac() == null) {
            return false;
        }
        if (other.getMac() != null && !other.getMac().equals(this.getMac())) {
            return false;
        }
        if (other.getMacAlgorithm() == null ^ this.getMacAlgorithm() == null) {
            return false;
        }
        if (other.getMacAlgorithm() != null && !other.getMacAlgorithm().equals(this.getMacAlgorithm())) {
            return false;
        }
        if (other.getKeyId() == null ^ this.getKeyId() == null) {
            return false;
        }
        return other.getKeyId() == null || other.getKeyId().equals(this.getKeyId());
    }
}

