/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kms.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.kms.model.ReplicateKeyRequest;
import com.amazonaws.services.kms.model.Tag;
import com.amazonaws.services.kms.model.transform.TagJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.AwsJsonWriter;
import com.amazonaws.util.json.JsonUtils;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;

public class ReplicateKeyRequestMarshaller
implements Marshaller<Request<ReplicateKeyRequest>, ReplicateKeyRequest> {
    public Request<ReplicateKeyRequest> marshall(ReplicateKeyRequest replicateKeyRequest) {
        if (replicateKeyRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(ReplicateKeyRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)replicateKeyRequest, "AWSKMS");
        String target = "TrentService.ReplicateKey";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/";
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = new StringWriter();
            AwsJsonWriter jsonWriter = JsonUtils.getJsonWriter((Writer)stringWriter);
            jsonWriter.beginObject();
            if (replicateKeyRequest.getKeyId() != null) {
                String keyId = replicateKeyRequest.getKeyId();
                jsonWriter.name("KeyId");
                jsonWriter.value(keyId);
            }
            if (replicateKeyRequest.getReplicaRegion() != null) {
                String replicaRegion = replicateKeyRequest.getReplicaRegion();
                jsonWriter.name("ReplicaRegion");
                jsonWriter.value(replicaRegion);
            }
            if (replicateKeyRequest.getPolicy() != null) {
                String policy = replicateKeyRequest.getPolicy();
                jsonWriter.name("Policy");
                jsonWriter.value(policy);
            }
            if (replicateKeyRequest.getBypassPolicyLockoutSafetyCheck() != null) {
                Boolean bypassPolicyLockoutSafetyCheck = replicateKeyRequest.getBypassPolicyLockoutSafetyCheck();
                jsonWriter.name("BypassPolicyLockoutSafetyCheck");
                jsonWriter.value(bypassPolicyLockoutSafetyCheck.booleanValue());
            }
            if (replicateKeyRequest.getDescription() != null) {
                String description = replicateKeyRequest.getDescription();
                jsonWriter.name("Description");
                jsonWriter.value(description);
            }
            if (replicateKeyRequest.getTags() != null) {
                List<Tag> tags = replicateKeyRequest.getTags();
                jsonWriter.name("Tags");
                jsonWriter.beginArray();
                for (Tag tagsItem : tags) {
                    if (tagsItem == null) continue;
                    TagJsonMarshaller.getInstance().marshall(tagsItem, jsonWriter);
                }
                jsonWriter.endArray();
            }
            jsonWriter.endObject();
            jsonWriter.close();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        return request;
    }
}

