/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kms.model.transform;

import com.amazonaws.services.kms.model.RecipientInfo;
import com.amazonaws.transform.JsonUnmarshallerContext;
import com.amazonaws.transform.SimpleTypeJsonUnmarshallers;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.json.AwsJsonReader;

class RecipientInfoJsonUnmarshaller
implements Unmarshaller<RecipientInfo, JsonUnmarshallerContext> {
    private static RecipientInfoJsonUnmarshaller instance;

    RecipientInfoJsonUnmarshaller() {
    }

    public RecipientInfo unmarshall(JsonUnmarshallerContext context) throws Exception {
        AwsJsonReader reader = context.getReader();
        if (!reader.isContainer()) {
            reader.skipValue();
            return null;
        }
        RecipientInfo recipientInfo = new RecipientInfo();
        reader.beginObject();
        while (reader.hasNext()) {
            String name = reader.nextName();
            if (name.equals("KeyEncryptionAlgorithm")) {
                recipientInfo.setKeyEncryptionAlgorithm(SimpleTypeJsonUnmarshallers.StringJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (name.equals("AttestationDocument")) {
                recipientInfo.setAttestationDocument(SimpleTypeJsonUnmarshallers.ByteBufferJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            reader.skipValue();
        }
        reader.endObject();
        return recipientInfo;
    }

    public static RecipientInfoJsonUnmarshaller getInstance() {
        if (instance == null) {
            instance = new RecipientInfoJsonUnmarshaller();
        }
        return instance;
    }
}

