/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kms.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.kms.model.EncryptRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.AwsJsonWriter;
import com.amazonaws.util.json.JsonUtils;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;

public class EncryptRequestMarshaller
implements Marshaller<Request<EncryptRequest>, EncryptRequest> {
    public Request<EncryptRequest> marshall(EncryptRequest encryptRequest) {
        if (encryptRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(EncryptRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)encryptRequest, "AWSKMS");
        String target = "TrentService.Encrypt";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/";
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = new StringWriter();
            AwsJsonWriter jsonWriter = JsonUtils.getJsonWriter((Writer)stringWriter);
            jsonWriter.beginObject();
            if (encryptRequest.getKeyId() != null) {
                String keyId = encryptRequest.getKeyId();
                jsonWriter.name("KeyId");
                jsonWriter.value(keyId);
            }
            if (encryptRequest.getPlaintext() != null) {
                ByteBuffer plaintext = encryptRequest.getPlaintext();
                jsonWriter.name("Plaintext");
                jsonWriter.value(plaintext);
            }
            if (encryptRequest.getEncryptionContext() != null) {
                Map<String, String> encryptionContext = encryptRequest.getEncryptionContext();
                jsonWriter.name("EncryptionContext");
                jsonWriter.beginObject();
                for (Map.Entry entry : encryptionContext.entrySet()) {
                    String encryptionContextValue = (String)entry.getValue();
                    if (encryptionContextValue == null) continue;
                    jsonWriter.name((String)entry.getKey());
                    jsonWriter.value(encryptionContextValue);
                }
                jsonWriter.endObject();
            }
            if (encryptRequest.getGrantTokens() != null) {
                List<String> grantTokens = encryptRequest.getGrantTokens();
                jsonWriter.name("GrantTokens");
                jsonWriter.beginArray();
                for (String string : grantTokens) {
                    if (string == null) continue;
                    jsonWriter.value(string);
                }
                jsonWriter.endArray();
            }
            if (encryptRequest.getEncryptionAlgorithm() != null) {
                String encryptionAlgorithm = encryptRequest.getEncryptionAlgorithm();
                jsonWriter.name("EncryptionAlgorithm");
                jsonWriter.value(encryptionAlgorithm);
            }
            if (encryptRequest.getDryRun() != null) {
                Boolean dryRun = encryptRequest.getDryRun();
                jsonWriter.name("DryRun");
                jsonWriter.value(dryRun.booleanValue());
            }
            jsonWriter.endObject();
            jsonWriter.close();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        return request;
    }
}

