/*
 * Copyright 2010-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License").
 * You may not use this file except in compliance with the License.
 * A copy of the License is located at
 *
 *  http://aws.amazon.com/apache2.0
 *
 * or in the "license" file accompanying this file. This file is distributed
 * on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 * express or implied. See the License for the specific language governing
 * permissions and limitations under the License.
 */

package com.amazonaws.services.kms.model.transform;

import com.amazonaws.services.kms.model.*;
import com.amazonaws.util.DateUtils;
import com.amazonaws.util.json.AwsJsonWriter;

/**
 * JSON marshaller for POJO MultiRegionKey
 */
class MultiRegionKeyJsonMarshaller {

    public void marshall(MultiRegionKey multiRegionKey, AwsJsonWriter jsonWriter) throws Exception {
        jsonWriter.beginObject();
        if (multiRegionKey.getArn() != null) {
            String arn = multiRegionKey.getArn();
            jsonWriter.name("Arn");
            jsonWriter.value(arn);
        }
        if (multiRegionKey.getRegion() != null) {
            String region = multiRegionKey.getRegion();
            jsonWriter.name("Region");
            jsonWriter.value(region);
        }
        jsonWriter.endObject();
    }

    private static MultiRegionKeyJsonMarshaller instance;

    public static MultiRegionKeyJsonMarshaller getInstance() {
        if (instance == null)
            instance = new MultiRegionKeyJsonMarshaller();
        return instance;
    }
}
