/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kms.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.kms.model.GenerateDataKeyWithoutPlaintextRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.AwsJsonWriter;
import com.amazonaws.util.json.JsonUtils;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import java.util.Map;

public class GenerateDataKeyWithoutPlaintextRequestMarshaller
implements Marshaller<Request<GenerateDataKeyWithoutPlaintextRequest>, GenerateDataKeyWithoutPlaintextRequest> {
    public Request<GenerateDataKeyWithoutPlaintextRequest> marshall(GenerateDataKeyWithoutPlaintextRequest generateDataKeyWithoutPlaintextRequest) {
        if (generateDataKeyWithoutPlaintextRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(GenerateDataKeyWithoutPlaintextRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)generateDataKeyWithoutPlaintextRequest, "AWSKMS");
        String target = "TrentService.GenerateDataKeyWithoutPlaintext";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/";
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = new StringWriter();
            AwsJsonWriter jsonWriter = JsonUtils.getJsonWriter((Writer)stringWriter);
            jsonWriter.beginObject();
            if (generateDataKeyWithoutPlaintextRequest.getKeyId() != null) {
                String keyId = generateDataKeyWithoutPlaintextRequest.getKeyId();
                jsonWriter.name("KeyId");
                jsonWriter.value(keyId);
            }
            if (generateDataKeyWithoutPlaintextRequest.getEncryptionContext() != null) {
                Map<String, String> encryptionContext = generateDataKeyWithoutPlaintextRequest.getEncryptionContext();
                jsonWriter.name("EncryptionContext");
                jsonWriter.beginObject();
                for (Map.Entry<String, String> encryptionContextEntry : encryptionContext.entrySet()) {
                    String encryptionContextValue = encryptionContextEntry.getValue();
                    if (encryptionContextValue == null) continue;
                    jsonWriter.name(encryptionContextEntry.getKey());
                    jsonWriter.value(encryptionContextValue);
                }
                jsonWriter.endObject();
            }
            if (generateDataKeyWithoutPlaintextRequest.getKeySpec() != null) {
                String keySpec = generateDataKeyWithoutPlaintextRequest.getKeySpec();
                jsonWriter.name("KeySpec");
                jsonWriter.value(keySpec);
            }
            if (generateDataKeyWithoutPlaintextRequest.getNumberOfBytes() != null) {
                Integer numberOfBytes = generateDataKeyWithoutPlaintextRequest.getNumberOfBytes();
                jsonWriter.name("NumberOfBytes");
                jsonWriter.value((Number)numberOfBytes);
            }
            if (generateDataKeyWithoutPlaintextRequest.getGrantTokens() != null) {
                List<String> grantTokens = generateDataKeyWithoutPlaintextRequest.getGrantTokens();
                jsonWriter.name("GrantTokens");
                jsonWriter.beginArray();
                for (String grantTokensItem : grantTokens) {
                    if (grantTokensItem == null) continue;
                    jsonWriter.value(grantTokensItem);
                }
                jsonWriter.endArray();
            }
            jsonWriter.endObject();
            jsonWriter.close();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        return request;
    }
}

