/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesisvideo.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.kinesisvideo.model.GetSignalingChannelEndpointRequest;
import com.amazonaws.services.kinesisvideo.model.SingleMasterChannelEndpointConfiguration;
import com.amazonaws.services.kinesisvideo.model.transform.SingleMasterChannelEndpointConfigurationJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.AwsJsonWriter;
import com.amazonaws.util.json.JsonUtils;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;

public class GetSignalingChannelEndpointRequestMarshaller
implements Marshaller<Request<GetSignalingChannelEndpointRequest>, GetSignalingChannelEndpointRequest> {
    public Request<GetSignalingChannelEndpointRequest> marshall(GetSignalingChannelEndpointRequest getSignalingChannelEndpointRequest) {
        if (getSignalingChannelEndpointRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(GetSignalingChannelEndpointRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)getSignalingChannelEndpointRequest, "AWSKinesisVideo");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/getSignalingChannelEndpoint";
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = new StringWriter();
            AwsJsonWriter jsonWriter = JsonUtils.getJsonWriter((Writer)stringWriter);
            jsonWriter.beginObject();
            if (getSignalingChannelEndpointRequest.getChannelARN() != null) {
                String channelARN = getSignalingChannelEndpointRequest.getChannelARN();
                jsonWriter.name("ChannelARN");
                jsonWriter.value(channelARN);
            }
            if (getSignalingChannelEndpointRequest.getSingleMasterChannelEndpointConfiguration() != null) {
                SingleMasterChannelEndpointConfiguration singleMasterChannelEndpointConfiguration = getSignalingChannelEndpointRequest.getSingleMasterChannelEndpointConfiguration();
                jsonWriter.name("SingleMasterChannelEndpointConfiguration");
                SingleMasterChannelEndpointConfigurationJsonMarshaller.getInstance().marshall(singleMasterChannelEndpointConfiguration, jsonWriter);
            }
            jsonWriter.endObject();
            jsonWriter.close();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", "application/x-amz-json-1.0");
        }
        return request;
    }
}

