/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.kinesisvideo.service;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.amazonaws.AmazonClientException;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.Protocol;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSSessionCredentials;
import com.amazonaws.kinesisvideo.auth.KinesisVideoCredentials;
import com.amazonaws.kinesisvideo.auth.KinesisVideoCredentialsProvider;
import com.amazonaws.kinesisvideo.client.KinesisVideoClientConfiguration;
import com.amazonaws.kinesisvideo.client.PutMediaClient;
import com.amazonaws.kinesisvideo.common.exception.KinesisVideoException;
import com.amazonaws.kinesisvideo.common.function.Consumer;
import com.amazonaws.kinesisvideo.common.logging.Log;
import com.amazonaws.kinesisvideo.common.preconditions.Preconditions;
import com.amazonaws.kinesisvideo.internal.producer.client.KinesisVideoServiceClient;
import com.amazonaws.kinesisvideo.producer.StreamDescription;
import com.amazonaws.kinesisvideo.producer.StreamStatus;
import com.amazonaws.mobileconnectors.kinesisvideo.signing.KinesisVideoAndroidAWS4Signer;
import com.amazonaws.regions.Region;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.kinesisvideo.AWSKinesisVideo;
import com.amazonaws.services.kinesisvideo.AWSKinesisVideoClient;
import com.amazonaws.services.kinesisvideo.model.CreateStreamRequest;
import com.amazonaws.services.kinesisvideo.model.CreateStreamResult;
import com.amazonaws.services.kinesisvideo.model.DeleteStreamRequest;
import com.amazonaws.services.kinesisvideo.model.DeleteStreamResult;
import com.amazonaws.services.kinesisvideo.model.DescribeStreamRequest;
import com.amazonaws.services.kinesisvideo.model.DescribeStreamResult;
import com.amazonaws.services.kinesisvideo.model.GetDataEndpointRequest;
import com.amazonaws.services.kinesisvideo.model.GetDataEndpointResult;
import com.amazonaws.services.kinesisvideo.model.TagStreamRequest;
import com.amazonaws.services.kinesisvideo.model.TagStreamResult;
import com.amazonaws.util.StringUtils;
import java.io.InputStream;
import java.net.URI;
import java.util.Date;
import java.util.Map;

public final class KinesisVideoAndroidServiceClient
implements KinesisVideoServiceClient {
    private static final int RECEIVE_TIMEOUT_1HR = 3600000;
    private static final String ABSOLUTE_TIMECODE = "ABSOLUTE";
    private static final String RELATIVE_TIMECODE = "RELATIVE";
    private final Log log;
    private KinesisVideoClientConfiguration configuration;

    private static AWSKinesisVideoClient createAwsKinesisVideoClient(KinesisVideoCredentialsProvider credentialsProvider, Region region, String endpoint, int timeoutInMillis) throws KinesisVideoException {
        AWSCredentials credentials = KinesisVideoAndroidServiceClient.createAwsCredentials(credentialsProvider);
        return KinesisVideoAndroidServiceClient.createAwsKinesisVideoClient(credentials, region, endpoint, timeoutInMillis);
    }

    private static AWSKinesisVideoClient createAwsKinesisVideoClient(AWSCredentialsProvider awsCredentialsProvider, Region region, String endpoint, int timeoutInMillis) throws KinesisVideoException {
        AWSCredentials credentials = awsCredentialsProvider.getCredentials();
        return KinesisVideoAndroidServiceClient.createAwsKinesisVideoClient(credentials, region, endpoint, timeoutInMillis);
    }

    private static AWSKinesisVideoClient createAwsKinesisVideoClient(AWSCredentials credentials, Region region, String endpoint, int timeoutInMillis) throws KinesisVideoException {
        ClientConfiguration clientConfiguration = KinesisVideoAndroidServiceClient.createClientConfiguration(timeoutInMillis);
        AWSKinesisVideoClient awsKinesisVideoClient = new AWSKinesisVideoClient(credentials, clientConfiguration);
        awsKinesisVideoClient.setRegion(region);
        awsKinesisVideoClient.setSignerRegionOverride(region.getName());
        awsKinesisVideoClient.setServiceNameIntern("kinesisvideo");
        awsKinesisVideoClient.setEndpoint(endpoint);
        return awsKinesisVideoClient;
    }

    private static AWSCredentials createAwsCredentials(@NonNull KinesisVideoCredentialsProvider credentialsProvider) throws KinesisVideoException {
        Preconditions.checkNotNull(credentialsProvider);
        final KinesisVideoCredentials kinesisVideoCredentials = credentialsProvider.getCredentials();
        AWSSessionCredentials credentials = new AWSSessionCredentials(){

            public String getSessionToken() {
                return kinesisVideoCredentials.getSessionToken();
            }

            public String getAWSAccessKeyId() {
                return kinesisVideoCredentials.getAccessKey();
            }

            public String getAWSSecretKey() {
                return kinesisVideoCredentials.getSecretKey();
            }
        };
        return credentials;
    }

    private static ClientConfiguration createClientConfiguration(int timeoutInMillis) {
        return new ClientConfiguration().withProtocol(Protocol.HTTPS).withConnectionTimeout(timeoutInMillis).withMaxConnections(10).withSocketTimeout(timeoutInMillis);
    }

    public KinesisVideoAndroidServiceClient(@NonNull Log log) {
        this.log = Preconditions.checkNotNull(log);
    }

    @NonNull
    public static AWSKinesisVideo getAwsKinesisVideoClient(@NonNull AWSCredentialsProvider credentialsProvider, @NonNull Region region, @NonNull String endpoint, int timeoutInMillis) throws KinesisVideoException {
        return KinesisVideoAndroidServiceClient.createAwsKinesisVideoClient(credentialsProvider, region, endpoint, timeoutInMillis);
    }

    @Override
    public void initialize(@NonNull KinesisVideoClientConfiguration kinesisVideoClientConfiguration) throws KinesisVideoException {
        this.configuration = Preconditions.checkNotNull(kinesisVideoClientConfiguration);
    }

    @Override
    public String createStream(@NonNull String streamName, @NonNull String deviceName, @NonNull String contentType, @Nullable String kmsKeyId, long retentionPeriodInHours, long timeoutInMillis, @Nullable KinesisVideoCredentialsProvider credentialsProvider) throws KinesisVideoException {
        CreateStreamResult createStreamResult;
        AWSKinesisVideoClient serviceClient = KinesisVideoAndroidServiceClient.createAwsKinesisVideoClient(credentialsProvider, Region.getRegion((Regions)Regions.fromName((String)this.configuration.getRegion())), this.configuration.getEndpoint(), (int)timeoutInMillis);
        CreateStreamRequest createStreamRequest = new CreateStreamRequest().withStreamName(streamName).withDeviceName(deviceName).withMediaType(contentType).withKmsKeyId(StringUtils.isBlank((CharSequence)kmsKeyId) ? null : kmsKeyId).withDataRetentionInHours((int)retentionPeriodInHours).withTags(null);
        this.log.debug("calling create stream: " + createStreamRequest.toString());
        try {
            createStreamResult = serviceClient.createStream(createStreamRequest);
        }
        catch (AmazonClientException e) {
            this.log.exception(e, "Service call failed.", new Object[0]);
            throw new KinesisVideoException(e);
        }
        this.log.debug("create stream result: " + createStreamResult.toString());
        return createStreamResult.getStreamARN();
    }

    @Override
    public StreamDescription describeStream(@NonNull String streamName, long timeoutInMillis, @Nullable KinesisVideoCredentialsProvider credentialsProvider) throws KinesisVideoException {
        DescribeStreamResult describeStreamResult;
        AWSKinesisVideoClient serviceClient = KinesisVideoAndroidServiceClient.createAwsKinesisVideoClient(credentialsProvider, Region.getRegion((Regions)Regions.fromName((String)this.configuration.getRegion())), this.configuration.getEndpoint(), (int)timeoutInMillis);
        DescribeStreamRequest describeStreamRequest = new DescribeStreamRequest().withStreamName(streamName);
        this.log.debug("calling describe stream: " + describeStreamRequest.toString());
        try {
            describeStreamResult = serviceClient.describeStream(describeStreamRequest);
        }
        catch (AmazonClientException e) {
            this.log.exception(e, "Service call failed.", new Object[0]);
            throw new KinesisVideoException(e);
        }
        if (null == describeStreamResult) {
            this.log.debug("describe stream returned null");
            return null;
        }
        this.log.debug("describe stream result: " + describeStreamResult.toString());
        return KinesisVideoAndroidServiceClient.toStreamDescription(describeStreamResult);
    }

    @Override
    public void deleteStream(@NonNull String streamName, @NonNull String version, Date creationTime, long timeoutInMillis, @Nullable KinesisVideoCredentialsProvider credentialsProvider) throws KinesisVideoException {
        DeleteStreamResult deleteStreamResult;
        AWSKinesisVideoClient serviceClient = KinesisVideoAndroidServiceClient.createAwsKinesisVideoClient(credentialsProvider, Region.getRegion((Regions)Regions.fromName((String)this.configuration.getRegion())), this.configuration.getEndpoint(), (int)timeoutInMillis);
        StreamDescription streamDescription = this.describeStream(streamName, timeoutInMillis, credentialsProvider);
        DeleteStreamRequest deleteStreamRequest = new DeleteStreamRequest().withStreamARN(streamDescription.getStreamArn()).withCurrentVersion(streamDescription.getUpdateVersion());
        this.log.debug("calling delete stream: " + deleteStreamRequest.toString());
        try {
            deleteStreamResult = serviceClient.deleteStream(deleteStreamRequest);
        }
        catch (AmazonClientException e) {
            this.log.exception(e, "Service call failed.", new Object[0]);
            throw new KinesisVideoException(e);
        }
        this.log.debug("delete stream result: " + deleteStreamResult.toString());
    }

    @Override
    public void tagStream(@NonNull String streamArn, @Nullable Map<String, String> tags, long timeoutInMillis, @Nullable KinesisVideoCredentialsProvider credentialsProvider) throws KinesisVideoException {
        TagStreamResult tagStreamResult;
        AWSKinesisVideoClient serviceClient = KinesisVideoAndroidServiceClient.createAwsKinesisVideoClient(credentialsProvider, Region.getRegion((Regions)Regions.fromName((String)this.configuration.getRegion())), this.configuration.getEndpoint(), (int)timeoutInMillis);
        TagStreamRequest tagStreamRequest = new TagStreamRequest().withStreamARN(streamArn).withTags(tags);
        this.log.debug("calling tag resource: " + tagStreamRequest.toString());
        try {
            tagStreamResult = serviceClient.tagStream(tagStreamRequest);
        }
        catch (AmazonClientException e) {
            this.log.exception(e, "Service call failed.", new Object[0]);
            throw new KinesisVideoException(e);
        }
        this.log.debug("tag resource result: " + tagStreamResult.toString());
    }

    @Override
    public String getDataEndpoint(@NonNull String streamName, @NonNull String apiName, long timeoutInMillis, @Nullable KinesisVideoCredentialsProvider credentialsProvider) throws KinesisVideoException {
        GetDataEndpointResult getDataEndpointResult;
        AWSKinesisVideoClient serviceClient = KinesisVideoAndroidServiceClient.createAwsKinesisVideoClient(credentialsProvider, Region.getRegion((Regions)Regions.fromName((String)this.configuration.getRegion())), this.configuration.getEndpoint(), (int)timeoutInMillis);
        GetDataEndpointRequest getDataEndpointRequest = new GetDataEndpointRequest().withStreamName(streamName).withAPIName(apiName);
        this.log.debug("calling get data endpoint: " + getDataEndpointRequest.toString());
        try {
            getDataEndpointResult = serviceClient.getDataEndpoint(getDataEndpointRequest);
        }
        catch (AmazonClientException e) {
            this.log.exception(e, "Service call failed.", new Object[0]);
            throw new KinesisVideoException(e);
        }
        this.log.debug("get data endpoint result: " + getDataEndpointResult.toString());
        return getDataEndpointResult.getDataEndpoint();
    }

    @Override
    public void putMedia(@NonNull String streamName, @NonNull String containerType, long streamStartTimeInMillis, boolean absoluteFragmentTimes, boolean ackRequired, @NonNull String dataEndpoint, long timeoutInMillis, @Nullable KinesisVideoCredentialsProvider credentialsProvider, @NonNull InputStream dataInputStream, @NonNull Consumer<InputStream> acksConsumer, @Nullable Consumer<Exception> completionCallback) throws KinesisVideoException {
        AWSCredentials credentials = KinesisVideoAndroidServiceClient.createAwsCredentials(credentialsProvider);
        KinesisVideoAndroidAWS4Signer signer = new KinesisVideoAndroidAWS4Signer(credentials, this.configuration);
        URI putMediaUri = URI.create(dataEndpoint + "/putMedia");
        String timecodeType = absoluteFragmentTimes ? ABSOLUTE_TIMECODE : RELATIVE_TIMECODE;
        PutMediaClient.Builder putMediaClientBuilder = PutMediaClient.builder().receiveTimeout(3600000).timestamp(streamStartTimeInMillis).signWith(signer).receiveCompletion(completionCallback).receiveAcks(acksConsumer).streamName(streamName).mkvStream(dataInputStream).fragmentTimecodeType(timecodeType).putMediaDestinationUri(putMediaUri);
        PutMediaClient putMediaClient = putMediaClientBuilder.build();
        putMediaClient.putMediaInBackground();
    }

    private static StreamDescription toStreamDescription(@NonNull DescribeStreamResult result) {
        Preconditions.checkNotNull(result);
        return new StreamDescription(0, result.getStreamInfo().getDeviceName(), result.getStreamInfo().getStreamName(), result.getStreamInfo().getMediaType(), result.getStreamInfo().getVersion(), result.getStreamInfo().getStreamARN(), StreamStatus.valueOf(result.getStreamInfo().getStatus()), result.getStreamInfo().getCreationTime().getTime());
    }
}

