/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.kinesisvideo.encoding;

import android.media.MediaCodec;
import android.media.MediaCodecInfo;
import android.media.MediaCrypto;
import android.media.MediaFormat;
import android.util.Log;
import android.view.Surface;
import com.amazonaws.kinesisvideo.client.mediasource.CameraMediaSourceConfiguration;
import java.io.IOException;
import java.util.ArrayList;

public class EncoderFactory {
    private static final String TAG = EncoderFactory.class.getSimpleName();
    private static final Surface NULL_SURFACE = null;
    private static final MediaCrypto NULL_CRYPTO = null;
    private static final int IFRAME_EVERY_2_SEC = 2;

    public static MediaCodec createConfiguredEncoder(CameraMediaSourceConfiguration mediaSourceConfiguration) {
        return EncoderFactory.createMediaCodec(mediaSourceConfiguration);
    }

    private static MediaCodec createMediaCodec(CameraMediaSourceConfiguration mediaSourceConfiguration) {
        try {
            MediaCodec encoder = MediaCodec.createEncoderByType((String)mediaSourceConfiguration.getEncoderMimeType());
            try {
                encoder.configure(EncoderFactory.configureMediaFormat(mediaSourceConfiguration, 21), NULL_SURFACE, NULL_CRYPTO, 1);
                EncoderFactory.logSupportedColorFormats(encoder, mediaSourceConfiguration);
            }
            catch (MediaCodec.CodecException e) {
                Log.d((String)TAG, (String)"Failed configuring MediaCodec with Semi-planar pixel format, falling back to planar");
                encoder.configure(EncoderFactory.configureMediaFormat(mediaSourceConfiguration, 19), NULL_SURFACE, NULL_CRYPTO, 1);
                EncoderFactory.logSupportedColorFormats(encoder, mediaSourceConfiguration);
            }
            return encoder;
        }
        catch (IOException e) {
            throw new RuntimeException("unable to create encoder", e);
        }
    }

    private static MediaFormat configureMediaFormat(CameraMediaSourceConfiguration mediaSourceConfiguration, int colorFormat) {
        Log.d((String)TAG, (String)(mediaSourceConfiguration.getEncoderMimeType() + " output " + mediaSourceConfiguration.getHorizontalResolution() + "x" + mediaSourceConfiguration.getVerticalResolution() + " @" + mediaSourceConfiguration.getBitRate()));
        MediaFormat format = MediaFormat.createVideoFormat((String)mediaSourceConfiguration.getEncoderMimeType(), (int)mediaSourceConfiguration.getHorizontalResolution(), (int)mediaSourceConfiguration.getVerticalResolution());
        format.setInteger("color-format", colorFormat);
        format.setString("mime", mediaSourceConfiguration.getEncoderMimeType());
        format.setInteger("bitrate", mediaSourceConfiguration.getBitRate());
        format.setInteger("frame-rate", mediaSourceConfiguration.getFrameRate());
        format.setInteger("i-frame-interval", 2);
        Log.d((String)TAG, (String)("format: " + format));
        return format;
    }

    private static void logSupportedColorFormats(MediaCodec encoder, CameraMediaSourceConfiguration mediaSourceConfiguration) {
        MediaCodecInfo.CodecCapabilities capabilities = encoder.getCodecInfo().getCapabilitiesForType(mediaSourceConfiguration.getEncoderMimeType());
        int[] colorFormats = capabilities.colorFormats;
        ArrayList<Integer> formatsList = new ArrayList<Integer>(colorFormats.length);
        for (int fmt : colorFormats) {
            formatsList.add(fmt);
        }
        Log.d((String)TAG, (String)("Supported color formats: " + ((Object)formatsList).toString()));
    }
}

