/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.kinesisvideo.camera;

import android.content.Context;
import android.media.Image;
import android.media.ImageReader;
import android.util.Log;
import android.view.Surface;
import com.amazonaws.kinesisvideo.client.mediasource.CameraMediaSourceConfiguration;
import com.amazonaws.kinesisvideo.common.exception.KinesisVideoException;
import com.amazonaws.mobileconnectors.kinesisvideo.camera.CameraAdapter;
import com.amazonaws.mobileconnectors.kinesisvideo.camera.EncodingCancellationToken;
import com.amazonaws.mobileconnectors.kinesisvideo.encoding.EncoderWrapper;
import com.amazonaws.mobileconnectors.kinesisvideo.mediasource.android.AndroidCameraMediaSource;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class CameraFramesSource {
    private static final String TAG = CameraFramesSource.class.getSimpleName();
    private EncoderWrapper mEncoderWrapper;
    private EncoderWrapper.CodecPrivateDataAvailableListener mCodecPrivateDataListener;
    private EncoderWrapper.FrameAvailableListener mFrameAvailableListener;
    private CameraAdapter mCameraAdapter;
    private boolean mIsReleased = false;
    private final ImageReader mImageReader;
    private final CameraMediaSourceConfiguration mMediaSourceConfiguration;
    private final EncodingCancellationToken mEncodingCancellationToken;

    public CameraFramesSource(ImageReader imageReader, CameraMediaSourceConfiguration mediaSourceConfiguration, EncodingCancellationToken encodingCancellationToken) {
        this.mMediaSourceConfiguration = mediaSourceConfiguration;
        this.mEncodingCancellationToken = encodingCancellationToken;
        this.mImageReader = imageReader;
        this.mImageReader.setOnImageAvailableListener(this.getOnImageAvailableListener(), null);
    }

    private ImageReader.OnImageAvailableListener getOnImageAvailableListener() {
        return new ImageReader.OnImageAvailableListener(){

            public void onImageAvailable(ImageReader imageReader) {
                Image image = imageReader.acquireNextImage();
                CameraFramesSource.this.mEncoderWrapper.encodeFrame(image, CameraFramesSource.this.mEncodingCancellationToken.isEncodingCancelled());
                image.close();
                if (CameraFramesSource.this.mEncodingCancellationToken.isEncodingCancelled()) {
                    CameraFramesSource.this.release();
                    return;
                }
            }
        };
    }

    public void startEncoding(Context context, List<Surface> previewSurfaces, String cameraId) {
        ArrayList<Surface> cameraOutputSurfaces = new ArrayList<Surface>();
        cameraOutputSurfaces.addAll(previewSurfaces);
        cameraOutputSurfaces.add(this.mImageReader.getSurface());
        CameraFramesSourceRunnableWrapper.startEncoding(this, context, cameraOutputSurfaces, cameraId);
    }

    private void startCapturing(Context context, List<Surface> cameraOutputSurfaces, String cameraId) throws IOException {
        try {
            this.mEncoderWrapper = new EncoderWrapper(this.mMediaSourceConfiguration);
            this.mEncoderWrapper.setCodecPrivateDataAvailableListener(this.mCodecPrivateDataListener);
            this.mEncoderWrapper.setEncodedFrameAvailableListener(this.mFrameAvailableListener);
            this.prepareCameraAndPreview(context, cameraOutputSurfaces, cameraId);
        }
        catch (Throwable e) {
            Log.e((String)TAG, (String)("encoder loop exception" + CameraFramesSource.threadId()), (Throwable)e);
        }
    }

    public void setCodecPrivateDataListener(EncoderWrapper.CodecPrivateDataAvailableListener listener) {
        this.mCodecPrivateDataListener = listener;
    }

    public void setFramesListener(EncoderWrapper.FrameAvailableListener listener) {
        this.mFrameAvailableListener = listener;
    }

    private void prepareCameraAndPreview(Context context, List<Surface> cameraOutputSurfaces, String cameraId) {
        if (this.mCameraAdapter != null) {
            Log.e((String)TAG, (String)("starting camera frames source second time" + CameraFramesSource.threadId()));
            throw new RuntimeException("starting camera frames source second time");
        }
        this.mCameraAdapter = new CameraAdapter(context, cameraId);
        Log.i((String)TAG, (String)"camera adapter");
        this.mCameraAdapter.openCamera(this.startPreviewWhenReady(cameraOutputSurfaces));
    }

    private void release() {
        if (this.mIsReleased) {
            return;
        }
        this.mIsReleased = true;
        Log.i((String)TAG, (String)"releasing everything");
        this.mEncoderWrapper.stop();
        this.releaseCamera();
        Log.i((String)TAG, (String)"released everything");
    }

    private void releaseCamera() {
        try {
            this.mCameraAdapter.closeCamera();
        }
        catch (Throwable e) {
            Log.e((String)TAG, (String)"error releasing camera");
        }
    }

    private AndroidCameraMediaSource.OpenCameraCallback startPreviewWhenReady(final List<Surface> cameraOutputSurfaces) {
        return new AndroidCameraMediaSource.OpenCameraCallback(){

            @Override
            public void onOpened() {
                Log.i((String)TAG, (String)("camera opened" + CameraFramesSource.threadId()));
                CameraFramesSource.this.mCameraAdapter.startPreview(cameraOutputSurfaces, CameraFramesSource.this.getCaptureCallback());
            }

            @Override
            public void onError(KinesisVideoException e) {
                Log.e((String)TAG, (String)("failed to open camera" + CameraFramesSource.threadId()), (Throwable)e);
                CameraFramesSource.this.release();
                throw new RuntimeException(e);
            }
        };
    }

    private AndroidCameraMediaSource.CaptureCallback getCaptureCallback() {
        return new AndroidCameraMediaSource.CaptureCallback(){

            @Override
            public void onStarted() {
                Log.i((String)TAG, (String)("capture started" + CameraFramesSource.threadId()));
            }

            @Override
            public void onFailed() {
                Log.i((String)TAG, (String)("capture failed" + CameraFramesSource.threadId()));
            }
        };
    }

    private static String threadId() {
        return " | threadId=" + Thread.currentThread().getId();
    }

    private static class CameraFramesSourceRunnableWrapper
    implements Runnable {
        private final List<Surface> mCameraOutputSurfaces;
        private final CameraFramesSource mCameraFramesSource;
        private final Context mContext;
        private final String mCameraId;

        private CameraFramesSourceRunnableWrapper(CameraFramesSource cameraFramesSource, Context context, List<Surface> cameraOutputSurfaces, String cameraId) {
            this.mCameraFramesSource = cameraFramesSource;
            this.mContext = context;
            this.mCameraOutputSurfaces = cameraOutputSurfaces;
            this.mCameraId = cameraId;
        }

        @Override
        public void run() {
            try {
                this.mCameraFramesSource.startCapturing(this.mContext, this.mCameraOutputSurfaces, this.mCameraId);
            }
            catch (Throwable th) {
                th.printStackTrace();
            }
        }

        public static void startEncoding(CameraFramesSource test, Context context, List<Surface> cameraOutputSurfaces, String cameraId) {
            CameraFramesSourceRunnableWrapper wrapper = new CameraFramesSourceRunnableWrapper(test, context, cameraOutputSurfaces, cameraId);
            Thread th = new Thread((Runnable)wrapper, "CameraFramesSource");
            th.start();
        }
    }
}

