/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.kinesisvideo.auth;

import android.support.annotation.NonNull;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSSessionCredentials;
import com.amazonaws.auth.CognitoCredentialsProvider;
import com.amazonaws.kinesisvideo.auth.AbstractKinesisVideoCredentialsProvider;
import com.amazonaws.kinesisvideo.auth.KinesisVideoCredentials;
import com.amazonaws.kinesisvideo.common.exception.KinesisVideoException;
import com.amazonaws.kinesisvideo.common.logging.Log;
import com.amazonaws.kinesisvideo.common.preconditions.Preconditions;
import java.util.Date;

public class KinesisVideoCredentialsProviderImpl
extends AbstractKinesisVideoCredentialsProvider {
    private final AWSCredentialsProvider credentialsProvider;
    private final Log log;

    public KinesisVideoCredentialsProviderImpl(@NonNull AWSCredentialsProvider awsCredentialsProvider, @NonNull Log log) {
        this.credentialsProvider = Preconditions.checkNotNull(awsCredentialsProvider);
        this.log = Preconditions.checkNotNull(log);
    }

    @Override
    protected KinesisVideoCredentials updateCredentials() throws KinesisVideoException {
        this.log.debug("Refreshing credentials");
        this.credentialsProvider.refresh();
        AWSCredentials awsCredentials = this.credentialsProvider.getCredentials();
        String sessionToken = null;
        if (awsCredentials instanceof AWSSessionCredentials) {
            AWSSessionCredentials sessionCredentials = (AWSSessionCredentials)awsCredentials;
            sessionToken = sessionCredentials.getSessionToken();
        }
        Date expiration = KinesisVideoCredentials.CREDENTIALS_NEVER_EXPIRE;
        if (this.credentialsProvider instanceof CognitoCredentialsProvider) {
            CognitoCredentialsProvider cognitoCredentialsProvider = (CognitoCredentialsProvider)this.credentialsProvider;
            expiration = cognitoCredentialsProvider.getSessionCredentitalsExpiration();
            this.log.debug("Refreshed token expiration is %s", expiration);
        }
        this.log.debug("Returning %scredentials with expiration %s", sessionToken == null ? "" : "session ", expiration);
        return new KinesisVideoCredentials(awsCredentials.getAWSAccessKeyId(), awsCredentials.getAWSSecretKey(), sessionToken, expiration);
    }
}

