/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.kinesisvideo.stream.throttling;

import com.amazonaws.kinesisvideo.stream.throttling.Throttler;

public class DiscreteTimePeriodsThrottler
implements Throttler {
    private static final int MS_IN_SEC = 1000;
    private final int mDiscreteTimeSegmentMs;
    private final int mOpsPerDiscreteTimeSegment;
    private int mOpsSinceSleep = 0;
    private long mLastSleepTime = 0L;

    public DiscreteTimePeriodsThrottler(int targetOpsPerSecond, int discretenessHz) {
        this.mDiscreteTimeSegmentMs = 1000 / discretenessHz;
        this.mOpsPerDiscreteTimeSegment = targetOpsPerSecond / discretenessHz;
    }

    @Override
    public void throttle() {
        this.ensureInitialized();
        if (this.shouldSleep()) {
            this.sleep(this.calculateSleepTime());
            this.reset();
        }
        ++this.mOpsSinceSleep;
    }

    private boolean shouldSleep() {
        return this.mOpsSinceSleep + 1 > this.mOpsPerDiscreteTimeSegment;
    }

    private long calculateSleepTime() {
        return this.mLastSleepTime + (long)this.mDiscreteTimeSegmentMs - this.getCurrentTimeMs();
    }

    private void sleep(long ms) {
        if (ms <= 0L) {
            return;
        }
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private void ensureInitialized() {
        if (this.mLastSleepTime == 0L) {
            this.reset();
        }
    }

    private long getCurrentTimeMs() {
        return System.currentTimeMillis();
    }

    private void reset() {
        this.mOpsSinceSleep = 0;
        this.mLastSleepTime = this.getCurrentTimeMs();
    }
}

