/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.kinesisvideo.socket;

import java.net.InetAddress;
import java.net.Socket;
import java.net.URI;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class SocketFactory {
    private static final int DEFAULT_HTTP_PORT = 80;
    private static final int DEFAULT_HTTPS_PORT = 443;
    private static final KeyManager[] NO_KEY_MANAGERS = null;

    public Socket createSocket(URI uri) {
        try {
            return this.openSocket(uri);
        }
        catch (Throwable e) {
            throw new RuntimeException("Exception while creating socket ! ", e);
        }
    }

    private Socket openSocket(URI uri) throws Exception {
        InetAddress address = this.toInetAddr(uri);
        int port = this.getPort(uri);
        return this.isHttps(uri) ? this.createSslSocket(address, port) : new Socket(address, port);
    }

    private Socket createSslSocket(InetAddress address, int port) throws Exception {
        SSLContext context = SSLContext.getInstance("TLSv1.2");
        context.init(NO_KEY_MANAGERS, this.trustAllCertificates(), new SecureRandom());
        return context.getSocketFactory().createSocket(address, port);
    }

    public TrustManager[] trustAllCertificates() {
        return new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
    }

    private boolean isHttps(URI uri) {
        return "https".equalsIgnoreCase(uri.getScheme());
    }

    private InetAddress toInetAddr(URI uri) throws Exception {
        return InetAddress.getByName(this.getHost(uri));
    }

    private String getHost(URI uri) {
        return uri.getHost();
    }

    private int getPort(URI uri) {
        if (uri.getPort() > 0) {
            return uri.getPort();
        }
        return this.isHttps(uri) ? 443 : 80;
    }
}

