/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.kinesisvideo.http;

import com.amazonaws.kinesisvideo.common.preconditions.Preconditions;
import com.amazonaws.kinesisvideo.http.HttpClient;
import com.amazonaws.kinesisvideo.http.HttpMethodName;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSession;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.ssl.SSLContextBuilder;

public final class KinesisVideoApacheHttpClient
implements HttpClient {
    private static final String HOST_HEADER = "Host";
    private static final int DEFAULT_CONNECTION_TIMEOUT_IN_MILLIS = 10000;
    private static final int DEFAULT_SOCKET_TIMEOUT_IN_MILLIS = 10000;
    private final Builder mBuilder;
    private final CloseableHttpClient mHttpClient;

    private KinesisVideoApacheHttpClient(Builder builder) {
        this.mBuilder = builder;
        this.mHttpClient = this.buildHttpClient();
    }

    public static Builder builder() {
        return new Builder();
    }

    public CloseableHttpResponse executeRequest() {
        HttpPost request = new HttpPost(this.mBuilder.mUri);
        for (Map.Entry entry : this.mBuilder.mHeaders.entrySet()) {
            request.addHeader((String)entry.getKey(), (String)entry.getValue());
        }
        try {
            StringEntity entity = new StringEntity(this.mBuilder.mContentInJson, this.mBuilder.mContentType.getCharset().toString());
            request.setEntity((HttpEntity)entity);
            return this.mHttpClient.execute((HttpUriRequest)request);
        }
        catch (IOException e) {
            throw new RuntimeException("Exception while doing a POST on the URI " + this.mBuilder.mUri, e);
        }
    }

    private CloseableHttpClient buildHttpClient() {
        SSLContextBuilder builder = new SSLContextBuilder();
        try {
            builder.loadTrustMaterial((org.apache.http.ssl.TrustStrategy)new TrustAllStrategy());
            SSLConnectionSocketFactory sslSocketFactory = new SSLConnectionSocketFactory(builder.build(), new String[]{"TLSv1.2"}, null, (HostnameVerifier)new NoOpHostNameVerifier());
            return HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslSocketFactory).setDefaultRequestConfig(RequestConfig.custom().setConnectTimeout(this.mBuilder.mConnectionTimeoutInMillis).build()).setDefaultSocketConfig(SocketConfig.custom().setSoTimeout(this.mBuilder.mSocketTimeoutInMillis).build()).build();
        }
        catch (KeyManagementException e) {
            throw new RuntimeException("Exception while building Apache http client", e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Exception while building Apache http client", e);
        }
        catch (KeyStoreException e) {
            throw new RuntimeException("Exception while building Apache http client", e);
        }
    }

    public void addHeaderUnsafe(String key, String value) {
        this.mBuilder.withHeader(key, value);
    }

    @Override
    public HttpMethodName getMethod() {
        return this.mBuilder.mMethod;
    }

    @Override
    public URI getUri() {
        return this.mBuilder.mUri;
    }

    @Override
    public Map<String, String> getHeaders() {
        return this.mBuilder.mHeaders;
    }

    @Override
    public InputStream getContent() {
        return new ByteArrayInputStream(this.mBuilder.mContentInJson.getBytes(StandardCharsets.US_ASCII));
    }

    @Override
    public void close() throws IOException {
        this.mHttpClient.close();
    }

    private static class NoOpHostNameVerifier
    implements HostnameVerifier {
        private NoOpHostNameVerifier() {
        }

        @Override
        public boolean verify(String hostname, SSLSession session) {
            return true;
        }
    }

    private static class TrustAllStrategy
    implements TrustStrategy {
        private TrustAllStrategy() {
        }

        public boolean isTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            return true;
        }
    }

    public static final class Builder {
        private final Map<String, String> mHeaders = new HashMap<String, String>();
        private URI mUri;
        private HttpMethodName mMethod;
        private int mConnectionTimeoutInMillis = 10000;
        private int mSocketTimeoutInMillis = 10000;
        private ContentType mContentType;
        private String mContentInJson;

        private Builder() {
        }

        public Builder withUri(URI uri) {
            this.mUri = uri;
            this.mHeaders.put(KinesisVideoApacheHttpClient.HOST_HEADER, uri.getHost());
            return this;
        }

        public Builder withMethod(HttpMethodName method) {
            this.mMethod = method;
            return this;
        }

        public Builder withHeader(String key, String value) {
            this.mHeaders.put(key, value);
            return this;
        }

        public Builder withConnectionTimeoutInMillis(int connectionTimeoutInMillis) {
            this.mConnectionTimeoutInMillis = connectionTimeoutInMillis;
            return this;
        }

        public Builder withSocketTimeoutInMillis(int socketTimeoutInMillis) {
            this.mSocketTimeoutInMillis = socketTimeoutInMillis;
            return this;
        }

        public Builder withContentType(ContentType contentType) {
            this.mContentType = contentType;
            return this;
        }

        public Builder withContentInJson(String contentInJson) {
            this.mContentInJson = contentInJson;
            return this;
        }

        public KinesisVideoApacheHttpClient build() {
            Preconditions.checkNotNull(this.mUri);
            return new KinesisVideoApacheHttpClient(this);
        }
    }
}

