/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.kinesisvideo.client;

import com.amazonaws.kinesisvideo.auth.KinesisVideoCredentialsProvider;
import com.amazonaws.kinesisvideo.client.KinesisVideoClientConfigurationDefaults;
import com.amazonaws.kinesisvideo.common.logging.OutputChannel;
import com.amazonaws.kinesisvideo.producer.StorageCallbacks;

public final class KinesisVideoClientConfiguration {
    private final String region;
    private final KinesisVideoCredentialsProvider credentialsProvider;
    private final StorageCallbacks storageCallbacks;
    private final String endpoint;
    private final OutputChannel logChannel;

    private KinesisVideoClientConfiguration(Builder builder) {
        this.region = builder.region;
        this.credentialsProvider = builder.credentialsProvider;
        this.storageCallbacks = builder.storageCallbacks;
        this.endpoint = builder.endpoint;
        this.logChannel = builder.logChannel;
    }

    public static Builder builder() {
        return new Builder();
    }

    private static void sanitizeBuilder(Builder builder) {
        String region = builder.region;
        String endpoint = builder.endpoint;
        if (region == null && endpoint == null) {
            builder.withRegion("us-west-2");
            builder.withEndpoint(KinesisVideoClientConfigurationDefaults.getControlPlaneEndpoint(builder.region));
        }
        if (region == null) {
            builder.withRegion("us-west-2");
        }
        if (endpoint == null) {
            builder.withEndpoint(KinesisVideoClientConfiguration.constructEndpoint(region));
        }
    }

    private static String constructEndpoint(String region) {
        return KinesisVideoClientConfigurationDefaults.getControlPlaneEndpoint(region);
    }

    public String getServiceName() {
        return "kinesisvideo";
    }

    public String getRegion() {
        return this.region;
    }

    public KinesisVideoCredentialsProvider getCredentialsProvider() {
        return this.credentialsProvider;
    }

    public StorageCallbacks getStorageCallbacks() {
        return this.storageCallbacks;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public OutputChannel getLogChannel() {
        return this.logChannel;
    }

    public static class Builder {
        private String region;
        private KinesisVideoCredentialsProvider credentialsProvider;
        private StorageCallbacks storageCallbacks = KinesisVideoClientConfigurationDefaults.NO_OP_STORAGE_CALLBACKS;
        private String endpoint;
        private OutputChannel logChannel;

        public Builder withRegion(String region) {
            this.region = region;
            return this;
        }

        public Builder withCredentialsProvider(KinesisVideoCredentialsProvider credentialsProvider) {
            this.credentialsProvider = credentialsProvider;
            return this;
        }

        public Builder withStorageCallbacks(StorageCallbacks storageCallbacks) {
            this.storageCallbacks = storageCallbacks;
            return this;
        }

        public Builder withEndpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public Builder withLogChannel(OutputChannel logChannel) {
            this.logChannel = logChannel;
            return this;
        }

        public KinesisVideoClientConfiguration build() {
            KinesisVideoClientConfiguration.sanitizeBuilder(this);
            return new KinesisVideoClientConfiguration(this);
        }
    }
}

