/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.kinesisvideo.auth;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.amazonaws.kinesisvideo.common.preconditions.Preconditions;
import java.io.Serializable;
import java.util.Date;

public class KinesisVideoCredentials
implements Serializable {
    public static final Date CREDENTIALS_NEVER_EXPIRE = new Date(Long.MAX_VALUE);
    public static final KinesisVideoCredentials EMPTY_KINESIS_VIDEO_CREDENTIALS = new KinesisVideoCredentials("", "");
    private final String accessKey;
    private final String secretKey;
    private final String sessionToken;
    private final Date expiration;

    public KinesisVideoCredentials(@NonNull String accessKey, @NonNull String secretKey) {
        this(accessKey, secretKey, null, CREDENTIALS_NEVER_EXPIRE);
    }

    public KinesisVideoCredentials(@NonNull String accessKey, @NonNull String secretKey, @Nullable String sessionToken, @NonNull Date expiration) {
        this.accessKey = Preconditions.checkNotNull(accessKey);
        this.secretKey = Preconditions.checkNotNull(secretKey);
        this.sessionToken = sessionToken;
        this.expiration = expiration;
    }

    @NonNull
    public String getAccessKey() {
        return this.accessKey;
    }

    @NonNull
    public String getSecretKey() {
        return this.secretKey;
    }

    @Nullable
    public String getSessionToken() {
        return this.sessionToken;
    }

    @NonNull
    public Date getExpiration() {
        return this.expiration;
    }
}

