/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesisvideosignaling.model.transform;

import com.amazonaws.services.kinesisvideosignaling.model.IceServer;
import com.amazonaws.transform.JsonUnmarshallerContext;
import com.amazonaws.transform.ListUnmarshaller;
import com.amazonaws.transform.SimpleTypeJsonUnmarshallers;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.json.AwsJsonReader;

class IceServerJsonUnmarshaller
implements Unmarshaller<IceServer, JsonUnmarshallerContext> {
    private static IceServerJsonUnmarshaller instance;

    IceServerJsonUnmarshaller() {
    }

    public IceServer unmarshall(JsonUnmarshallerContext context) throws Exception {
        AwsJsonReader reader = context.getReader();
        if (!reader.isContainer()) {
            reader.skipValue();
            return null;
        }
        IceServer iceServer = new IceServer();
        reader.beginObject();
        while (reader.hasNext()) {
            String name = reader.nextName();
            if (name.equals("Uris")) {
                iceServer.setUris(new ListUnmarshaller((Unmarshaller)SimpleTypeJsonUnmarshallers.StringJsonUnmarshaller.getInstance()).unmarshall(context));
                continue;
            }
            if (name.equals("Username")) {
                iceServer.setUsername(SimpleTypeJsonUnmarshallers.StringJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (name.equals("Password")) {
                iceServer.setPassword(SimpleTypeJsonUnmarshallers.StringJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (name.equals("Ttl")) {
                iceServer.setTtl(SimpleTypeJsonUnmarshallers.IntegerJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            reader.skipValue();
        }
        reader.endObject();
        return iceServer;
    }

    public static IceServerJsonUnmarshaller getInstance() {
        if (instance == null) {
            instance = new IceServerJsonUnmarshaller();
        }
        return instance;
    }
}

