/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitoidentity.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.cognitoidentity.model.GetPrincipalTagAttributeMapRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.AwsJsonWriter;
import com.amazonaws.util.json.JsonUtils;
import java.io.StringWriter;

public class GetPrincipalTagAttributeMapRequestMarshaller
implements Marshaller<Request<GetPrincipalTagAttributeMapRequest>, GetPrincipalTagAttributeMapRequest> {
    @Override
    public Request<GetPrincipalTagAttributeMapRequest> marshall(GetPrincipalTagAttributeMapRequest getPrincipalTagAttributeMapRequest) {
        if (getPrincipalTagAttributeMapRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(GetPrincipalTagAttributeMapRequest)");
        }
        DefaultRequest<GetPrincipalTagAttributeMapRequest> request = new DefaultRequest<GetPrincipalTagAttributeMapRequest>(getPrincipalTagAttributeMapRequest, "AmazonCognitoIdentity");
        String target = "AWSCognitoIdentityService.GetPrincipalTagAttributeMap";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/";
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = new StringWriter();
            AwsJsonWriter jsonWriter = JsonUtils.getJsonWriter(stringWriter);
            jsonWriter.beginObject();
            if (getPrincipalTagAttributeMapRequest.getIdentityPoolId() != null) {
                String identityPoolId = getPrincipalTagAttributeMapRequest.getIdentityPoolId();
                jsonWriter.name("IdentityPoolId");
                jsonWriter.value(identityPoolId);
            }
            if (getPrincipalTagAttributeMapRequest.getIdentityProviderName() != null) {
                String identityProviderName = getPrincipalTagAttributeMapRequest.getIdentityProviderName();
                jsonWriter.name("IdentityProviderName");
                jsonWriter.value(identityProviderName);
            }
            jsonWriter.endObject();
            jsonWriter.close();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        return request;
    }
}

