/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitoidentity.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.cognitoidentity.model.CognitoIdentityProvider;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CreateIdentityPoolRequest
extends AmazonWebServiceRequest
implements Serializable {
    private String identityPoolName;
    private Boolean allowUnauthenticatedIdentities;
    private Boolean allowClassicFlow;
    private Map<String, String> supportedLoginProviders;
    private String developerProviderName;
    private List<String> openIdConnectProviderARNs;
    private List<CognitoIdentityProvider> cognitoIdentityProviders;
    private List<String> samlProviderARNs;
    private Map<String, String> identityPoolTags;

    public String getIdentityPoolName() {
        return this.identityPoolName;
    }

    public void setIdentityPoolName(String identityPoolName) {
        this.identityPoolName = identityPoolName;
    }

    public CreateIdentityPoolRequest withIdentityPoolName(String identityPoolName) {
        this.identityPoolName = identityPoolName;
        return this;
    }

    public Boolean isAllowUnauthenticatedIdentities() {
        return this.allowUnauthenticatedIdentities;
    }

    public Boolean getAllowUnauthenticatedIdentities() {
        return this.allowUnauthenticatedIdentities;
    }

    public void setAllowUnauthenticatedIdentities(Boolean allowUnauthenticatedIdentities) {
        this.allowUnauthenticatedIdentities = allowUnauthenticatedIdentities;
    }

    public CreateIdentityPoolRequest withAllowUnauthenticatedIdentities(Boolean allowUnauthenticatedIdentities) {
        this.allowUnauthenticatedIdentities = allowUnauthenticatedIdentities;
        return this;
    }

    public Boolean isAllowClassicFlow() {
        return this.allowClassicFlow;
    }

    public Boolean getAllowClassicFlow() {
        return this.allowClassicFlow;
    }

    public void setAllowClassicFlow(Boolean allowClassicFlow) {
        this.allowClassicFlow = allowClassicFlow;
    }

    public CreateIdentityPoolRequest withAllowClassicFlow(Boolean allowClassicFlow) {
        this.allowClassicFlow = allowClassicFlow;
        return this;
    }

    public Map<String, String> getSupportedLoginProviders() {
        return this.supportedLoginProviders;
    }

    public void setSupportedLoginProviders(Map<String, String> supportedLoginProviders) {
        this.supportedLoginProviders = supportedLoginProviders;
    }

    public CreateIdentityPoolRequest withSupportedLoginProviders(Map<String, String> supportedLoginProviders) {
        this.supportedLoginProviders = supportedLoginProviders;
        return this;
    }

    public CreateIdentityPoolRequest addSupportedLoginProvidersEntry(String key, String value) {
        if (null == this.supportedLoginProviders) {
            this.supportedLoginProviders = new HashMap<String, String>();
        }
        if (this.supportedLoginProviders.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.supportedLoginProviders.put(key, value);
        return this;
    }

    public CreateIdentityPoolRequest clearSupportedLoginProvidersEntries() {
        this.supportedLoginProviders = null;
        return this;
    }

    public String getDeveloperProviderName() {
        return this.developerProviderName;
    }

    public void setDeveloperProviderName(String developerProviderName) {
        this.developerProviderName = developerProviderName;
    }

    public CreateIdentityPoolRequest withDeveloperProviderName(String developerProviderName) {
        this.developerProviderName = developerProviderName;
        return this;
    }

    public List<String> getOpenIdConnectProviderARNs() {
        return this.openIdConnectProviderARNs;
    }

    public void setOpenIdConnectProviderARNs(Collection<String> openIdConnectProviderARNs) {
        if (openIdConnectProviderARNs == null) {
            this.openIdConnectProviderARNs = null;
            return;
        }
        this.openIdConnectProviderARNs = new ArrayList<String>(openIdConnectProviderARNs);
    }

    public CreateIdentityPoolRequest withOpenIdConnectProviderARNs(String ... openIdConnectProviderARNs) {
        if (this.getOpenIdConnectProviderARNs() == null) {
            this.openIdConnectProviderARNs = new ArrayList<String>(openIdConnectProviderARNs.length);
        }
        for (String value : openIdConnectProviderARNs) {
            this.openIdConnectProviderARNs.add(value);
        }
        return this;
    }

    public CreateIdentityPoolRequest withOpenIdConnectProviderARNs(Collection<String> openIdConnectProviderARNs) {
        this.setOpenIdConnectProviderARNs(openIdConnectProviderARNs);
        return this;
    }

    public List<CognitoIdentityProvider> getCognitoIdentityProviders() {
        return this.cognitoIdentityProviders;
    }

    public void setCognitoIdentityProviders(Collection<CognitoIdentityProvider> cognitoIdentityProviders) {
        if (cognitoIdentityProviders == null) {
            this.cognitoIdentityProviders = null;
            return;
        }
        this.cognitoIdentityProviders = new ArrayList<CognitoIdentityProvider>(cognitoIdentityProviders);
    }

    public CreateIdentityPoolRequest withCognitoIdentityProviders(CognitoIdentityProvider ... cognitoIdentityProviders) {
        if (this.getCognitoIdentityProviders() == null) {
            this.cognitoIdentityProviders = new ArrayList<CognitoIdentityProvider>(cognitoIdentityProviders.length);
        }
        for (CognitoIdentityProvider value : cognitoIdentityProviders) {
            this.cognitoIdentityProviders.add(value);
        }
        return this;
    }

    public CreateIdentityPoolRequest withCognitoIdentityProviders(Collection<CognitoIdentityProvider> cognitoIdentityProviders) {
        this.setCognitoIdentityProviders(cognitoIdentityProviders);
        return this;
    }

    public List<String> getSamlProviderARNs() {
        return this.samlProviderARNs;
    }

    public void setSamlProviderARNs(Collection<String> samlProviderARNs) {
        if (samlProviderARNs == null) {
            this.samlProviderARNs = null;
            return;
        }
        this.samlProviderARNs = new ArrayList<String>(samlProviderARNs);
    }

    public CreateIdentityPoolRequest withSamlProviderARNs(String ... samlProviderARNs) {
        if (this.getSamlProviderARNs() == null) {
            this.samlProviderARNs = new ArrayList<String>(samlProviderARNs.length);
        }
        for (String value : samlProviderARNs) {
            this.samlProviderARNs.add(value);
        }
        return this;
    }

    public CreateIdentityPoolRequest withSamlProviderARNs(Collection<String> samlProviderARNs) {
        this.setSamlProviderARNs(samlProviderARNs);
        return this;
    }

    public Map<String, String> getIdentityPoolTags() {
        return this.identityPoolTags;
    }

    public void setIdentityPoolTags(Map<String, String> identityPoolTags) {
        this.identityPoolTags = identityPoolTags;
    }

    public CreateIdentityPoolRequest withIdentityPoolTags(Map<String, String> identityPoolTags) {
        this.identityPoolTags = identityPoolTags;
        return this;
    }

    public CreateIdentityPoolRequest addIdentityPoolTagsEntry(String key, String value) {
        if (null == this.identityPoolTags) {
            this.identityPoolTags = new HashMap<String, String>();
        }
        if (this.identityPoolTags.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.identityPoolTags.put(key, value);
        return this;
    }

    public CreateIdentityPoolRequest clearIdentityPoolTagsEntries() {
        this.identityPoolTags = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getIdentityPoolName() != null) {
            sb.append("IdentityPoolName: " + this.getIdentityPoolName() + ",");
        }
        if (this.getAllowUnauthenticatedIdentities() != null) {
            sb.append("AllowUnauthenticatedIdentities: " + this.getAllowUnauthenticatedIdentities() + ",");
        }
        if (this.getAllowClassicFlow() != null) {
            sb.append("AllowClassicFlow: " + this.getAllowClassicFlow() + ",");
        }
        if (this.getSupportedLoginProviders() != null) {
            sb.append("SupportedLoginProviders: " + this.getSupportedLoginProviders() + ",");
        }
        if (this.getDeveloperProviderName() != null) {
            sb.append("DeveloperProviderName: " + this.getDeveloperProviderName() + ",");
        }
        if (this.getOpenIdConnectProviderARNs() != null) {
            sb.append("OpenIdConnectProviderARNs: " + this.getOpenIdConnectProviderARNs() + ",");
        }
        if (this.getCognitoIdentityProviders() != null) {
            sb.append("CognitoIdentityProviders: " + this.getCognitoIdentityProviders() + ",");
        }
        if (this.getSamlProviderARNs() != null) {
            sb.append("SamlProviderARNs: " + this.getSamlProviderARNs() + ",");
        }
        if (this.getIdentityPoolTags() != null) {
            sb.append("IdentityPoolTags: " + this.getIdentityPoolTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getIdentityPoolName() == null ? 0 : this.getIdentityPoolName().hashCode());
        hashCode = 31 * hashCode + (this.getAllowUnauthenticatedIdentities() == null ? 0 : this.getAllowUnauthenticatedIdentities().hashCode());
        hashCode = 31 * hashCode + (this.getAllowClassicFlow() == null ? 0 : this.getAllowClassicFlow().hashCode());
        hashCode = 31 * hashCode + (this.getSupportedLoginProviders() == null ? 0 : this.getSupportedLoginProviders().hashCode());
        hashCode = 31 * hashCode + (this.getDeveloperProviderName() == null ? 0 : this.getDeveloperProviderName().hashCode());
        hashCode = 31 * hashCode + (this.getOpenIdConnectProviderARNs() == null ? 0 : this.getOpenIdConnectProviderARNs().hashCode());
        hashCode = 31 * hashCode + (this.getCognitoIdentityProviders() == null ? 0 : this.getCognitoIdentityProviders().hashCode());
        hashCode = 31 * hashCode + (this.getSamlProviderARNs() == null ? 0 : this.getSamlProviderARNs().hashCode());
        hashCode = 31 * hashCode + (this.getIdentityPoolTags() == null ? 0 : this.getIdentityPoolTags().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateIdentityPoolRequest)) {
            return false;
        }
        CreateIdentityPoolRequest other = (CreateIdentityPoolRequest)obj;
        if (other.getIdentityPoolName() == null ^ this.getIdentityPoolName() == null) {
            return false;
        }
        if (other.getIdentityPoolName() != null && !other.getIdentityPoolName().equals(this.getIdentityPoolName())) {
            return false;
        }
        if (other.getAllowUnauthenticatedIdentities() == null ^ this.getAllowUnauthenticatedIdentities() == null) {
            return false;
        }
        if (other.getAllowUnauthenticatedIdentities() != null && !other.getAllowUnauthenticatedIdentities().equals(this.getAllowUnauthenticatedIdentities())) {
            return false;
        }
        if (other.getAllowClassicFlow() == null ^ this.getAllowClassicFlow() == null) {
            return false;
        }
        if (other.getAllowClassicFlow() != null && !other.getAllowClassicFlow().equals(this.getAllowClassicFlow())) {
            return false;
        }
        if (other.getSupportedLoginProviders() == null ^ this.getSupportedLoginProviders() == null) {
            return false;
        }
        if (other.getSupportedLoginProviders() != null && !other.getSupportedLoginProviders().equals(this.getSupportedLoginProviders())) {
            return false;
        }
        if (other.getDeveloperProviderName() == null ^ this.getDeveloperProviderName() == null) {
            return false;
        }
        if (other.getDeveloperProviderName() != null && !other.getDeveloperProviderName().equals(this.getDeveloperProviderName())) {
            return false;
        }
        if (other.getOpenIdConnectProviderARNs() == null ^ this.getOpenIdConnectProviderARNs() == null) {
            return false;
        }
        if (other.getOpenIdConnectProviderARNs() != null && !other.getOpenIdConnectProviderARNs().equals(this.getOpenIdConnectProviderARNs())) {
            return false;
        }
        if (other.getCognitoIdentityProviders() == null ^ this.getCognitoIdentityProviders() == null) {
            return false;
        }
        if (other.getCognitoIdentityProviders() != null && !other.getCognitoIdentityProviders().equals(this.getCognitoIdentityProviders())) {
            return false;
        }
        if (other.getSamlProviderARNs() == null ^ this.getSamlProviderARNs() == null) {
            return false;
        }
        if (other.getSamlProviderARNs() != null && !other.getSamlProviderARNs().equals(this.getSamlProviderARNs())) {
            return false;
        }
        if (other.getIdentityPoolTags() == null ^ this.getIdentityPoolTags() == null) {
            return false;
        }
        return other.getIdentityPoolTags() == null || other.getIdentityPoolTags().equals(this.getIdentityPoolTags());
    }
}

