/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.securitytoken.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.securitytoken.model.PolicyDescriptorType;
import com.amazonaws.services.securitytoken.model.Tag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class AssumeRoleRequest
extends AmazonWebServiceRequest
implements Serializable {
    private String roleArn;
    private String roleSessionName;
    private List<PolicyDescriptorType> policyArns;
    private String policy;
    private Integer durationSeconds;
    private List<Tag> tags;
    private List<String> transitiveTagKeys;
    private String externalId;
    private String serialNumber;
    private String tokenCode;
    private String sourceIdentity;

    public String getRoleArn() {
        return this.roleArn;
    }

    public void setRoleArn(String roleArn) {
        this.roleArn = roleArn;
    }

    public AssumeRoleRequest withRoleArn(String roleArn) {
        this.roleArn = roleArn;
        return this;
    }

    public String getRoleSessionName() {
        return this.roleSessionName;
    }

    public void setRoleSessionName(String roleSessionName) {
        this.roleSessionName = roleSessionName;
    }

    public AssumeRoleRequest withRoleSessionName(String roleSessionName) {
        this.roleSessionName = roleSessionName;
        return this;
    }

    public List<PolicyDescriptorType> getPolicyArns() {
        return this.policyArns;
    }

    public void setPolicyArns(Collection<PolicyDescriptorType> policyArns) {
        if (policyArns == null) {
            this.policyArns = null;
            return;
        }
        this.policyArns = new ArrayList<PolicyDescriptorType>(policyArns);
    }

    public AssumeRoleRequest withPolicyArns(PolicyDescriptorType ... policyArns) {
        if (this.getPolicyArns() == null) {
            this.policyArns = new ArrayList<PolicyDescriptorType>(policyArns.length);
        }
        for (PolicyDescriptorType value : policyArns) {
            this.policyArns.add(value);
        }
        return this;
    }

    public AssumeRoleRequest withPolicyArns(Collection<PolicyDescriptorType> policyArns) {
        this.setPolicyArns(policyArns);
        return this;
    }

    public String getPolicy() {
        return this.policy;
    }

    public void setPolicy(String policy) {
        this.policy = policy;
    }

    public AssumeRoleRequest withPolicy(String policy) {
        this.policy = policy;
        return this;
    }

    public Integer getDurationSeconds() {
        return this.durationSeconds;
    }

    public void setDurationSeconds(Integer durationSeconds) {
        this.durationSeconds = durationSeconds;
    }

    public AssumeRoleRequest withDurationSeconds(Integer durationSeconds) {
        this.durationSeconds = durationSeconds;
        return this;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new ArrayList<Tag>(tags);
    }

    public AssumeRoleRequest withTags(Tag ... tags) {
        if (this.getTags() == null) {
            this.tags = new ArrayList<Tag>(tags.length);
        }
        for (Tag value : tags) {
            this.tags.add(value);
        }
        return this;
    }

    public AssumeRoleRequest withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public List<String> getTransitiveTagKeys() {
        return this.transitiveTagKeys;
    }

    public void setTransitiveTagKeys(Collection<String> transitiveTagKeys) {
        if (transitiveTagKeys == null) {
            this.transitiveTagKeys = null;
            return;
        }
        this.transitiveTagKeys = new ArrayList<String>(transitiveTagKeys);
    }

    public AssumeRoleRequest withTransitiveTagKeys(String ... transitiveTagKeys) {
        if (this.getTransitiveTagKeys() == null) {
            this.transitiveTagKeys = new ArrayList<String>(transitiveTagKeys.length);
        }
        for (String value : transitiveTagKeys) {
            this.transitiveTagKeys.add(value);
        }
        return this;
    }

    public AssumeRoleRequest withTransitiveTagKeys(Collection<String> transitiveTagKeys) {
        this.setTransitiveTagKeys(transitiveTagKeys);
        return this;
    }

    public String getExternalId() {
        return this.externalId;
    }

    public void setExternalId(String externalId) {
        this.externalId = externalId;
    }

    public AssumeRoleRequest withExternalId(String externalId) {
        this.externalId = externalId;
        return this;
    }

    public String getSerialNumber() {
        return this.serialNumber;
    }

    public void setSerialNumber(String serialNumber) {
        this.serialNumber = serialNumber;
    }

    public AssumeRoleRequest withSerialNumber(String serialNumber) {
        this.serialNumber = serialNumber;
        return this;
    }

    public String getTokenCode() {
        return this.tokenCode;
    }

    public void setTokenCode(String tokenCode) {
        this.tokenCode = tokenCode;
    }

    public AssumeRoleRequest withTokenCode(String tokenCode) {
        this.tokenCode = tokenCode;
        return this;
    }

    public String getSourceIdentity() {
        return this.sourceIdentity;
    }

    public void setSourceIdentity(String sourceIdentity) {
        this.sourceIdentity = sourceIdentity;
    }

    public AssumeRoleRequest withSourceIdentity(String sourceIdentity) {
        this.sourceIdentity = sourceIdentity;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getRoleArn() != null) {
            sb.append("RoleArn: " + this.getRoleArn() + ",");
        }
        if (this.getRoleSessionName() != null) {
            sb.append("RoleSessionName: " + this.getRoleSessionName() + ",");
        }
        if (this.getPolicyArns() != null) {
            sb.append("PolicyArns: " + this.getPolicyArns() + ",");
        }
        if (this.getPolicy() != null) {
            sb.append("Policy: " + this.getPolicy() + ",");
        }
        if (this.getDurationSeconds() != null) {
            sb.append("DurationSeconds: " + this.getDurationSeconds() + ",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: " + this.getTags() + ",");
        }
        if (this.getTransitiveTagKeys() != null) {
            sb.append("TransitiveTagKeys: " + this.getTransitiveTagKeys() + ",");
        }
        if (this.getExternalId() != null) {
            sb.append("ExternalId: " + this.getExternalId() + ",");
        }
        if (this.getSerialNumber() != null) {
            sb.append("SerialNumber: " + this.getSerialNumber() + ",");
        }
        if (this.getTokenCode() != null) {
            sb.append("TokenCode: " + this.getTokenCode() + ",");
        }
        if (this.getSourceIdentity() != null) {
            sb.append("SourceIdentity: " + this.getSourceIdentity());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getRoleArn() == null ? 0 : this.getRoleArn().hashCode());
        hashCode = 31 * hashCode + (this.getRoleSessionName() == null ? 0 : this.getRoleSessionName().hashCode());
        hashCode = 31 * hashCode + (this.getPolicyArns() == null ? 0 : this.getPolicyArns().hashCode());
        hashCode = 31 * hashCode + (this.getPolicy() == null ? 0 : this.getPolicy().hashCode());
        hashCode = 31 * hashCode + (this.getDurationSeconds() == null ? 0 : this.getDurationSeconds().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode = 31 * hashCode + (this.getTransitiveTagKeys() == null ? 0 : this.getTransitiveTagKeys().hashCode());
        hashCode = 31 * hashCode + (this.getExternalId() == null ? 0 : this.getExternalId().hashCode());
        hashCode = 31 * hashCode + (this.getSerialNumber() == null ? 0 : this.getSerialNumber().hashCode());
        hashCode = 31 * hashCode + (this.getTokenCode() == null ? 0 : this.getTokenCode().hashCode());
        hashCode = 31 * hashCode + (this.getSourceIdentity() == null ? 0 : this.getSourceIdentity().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssumeRoleRequest)) {
            return false;
        }
        AssumeRoleRequest other = (AssumeRoleRequest)obj;
        if (other.getRoleArn() == null ^ this.getRoleArn() == null) {
            return false;
        }
        if (other.getRoleArn() != null && !other.getRoleArn().equals(this.getRoleArn())) {
            return false;
        }
        if (other.getRoleSessionName() == null ^ this.getRoleSessionName() == null) {
            return false;
        }
        if (other.getRoleSessionName() != null && !other.getRoleSessionName().equals(this.getRoleSessionName())) {
            return false;
        }
        if (other.getPolicyArns() == null ^ this.getPolicyArns() == null) {
            return false;
        }
        if (other.getPolicyArns() != null && !other.getPolicyArns().equals(this.getPolicyArns())) {
            return false;
        }
        if (other.getPolicy() == null ^ this.getPolicy() == null) {
            return false;
        }
        if (other.getPolicy() != null && !other.getPolicy().equals(this.getPolicy())) {
            return false;
        }
        if (other.getDurationSeconds() == null ^ this.getDurationSeconds() == null) {
            return false;
        }
        if (other.getDurationSeconds() != null && !other.getDurationSeconds().equals(this.getDurationSeconds())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.getTransitiveTagKeys() == null ^ this.getTransitiveTagKeys() == null) {
            return false;
        }
        if (other.getTransitiveTagKeys() != null && !other.getTransitiveTagKeys().equals(this.getTransitiveTagKeys())) {
            return false;
        }
        if (other.getExternalId() == null ^ this.getExternalId() == null) {
            return false;
        }
        if (other.getExternalId() != null && !other.getExternalId().equals(this.getExternalId())) {
            return false;
        }
        if (other.getSerialNumber() == null ^ this.getSerialNumber() == null) {
            return false;
        }
        if (other.getSerialNumber() != null && !other.getSerialNumber().equals(this.getSerialNumber())) {
            return false;
        }
        if (other.getTokenCode() == null ^ this.getTokenCode() == null) {
            return false;
        }
        if (other.getTokenCode() != null && !other.getTokenCode().equals(this.getTokenCode())) {
            return false;
        }
        if (other.getSourceIdentity() == null ^ this.getSourceIdentity() == null) {
            return false;
        }
        return other.getSourceIdentity() == null || other.getSourceIdentity().equals(this.getSourceIdentity());
    }
}

