/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.securitytoken.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.securitytoken.model.AssumeRoleRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class AssumeRoleRequestMarshaller
implements Marshaller<Request<AssumeRoleRequest>, AssumeRoleRequest> {
    @Override
    public Request<AssumeRoleRequest> marshall(AssumeRoleRequest assumeRoleRequest) {
        String prefix;
        if (assumeRoleRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(AssumeRoleRequest)");
        }
        DefaultRequest<AssumeRoleRequest> request = new DefaultRequest<AssumeRoleRequest>(assumeRoleRequest, "AWSSecurityTokenService");
        request.addParameter("Action", "AssumeRole");
        request.addParameter("Version", "2011-06-15");
        if (assumeRoleRequest.getRoleArn() != null) {
            prefix = "RoleArn";
            String roleArn = assumeRoleRequest.getRoleArn();
            request.addParameter(prefix, StringUtils.fromString(roleArn));
        }
        if (assumeRoleRequest.getRoleSessionName() != null) {
            prefix = "RoleSessionName";
            String roleSessionName = assumeRoleRequest.getRoleSessionName();
            request.addParameter(prefix, StringUtils.fromString(roleSessionName));
        }
        if (assumeRoleRequest.getPolicy() != null) {
            prefix = "Policy";
            String policy = assumeRoleRequest.getPolicy();
            request.addParameter(prefix, StringUtils.fromString(policy));
        }
        if (assumeRoleRequest.getDurationSeconds() != null) {
            prefix = "DurationSeconds";
            Integer durationSeconds = assumeRoleRequest.getDurationSeconds();
            request.addParameter(prefix, StringUtils.fromInteger(durationSeconds));
        }
        if (assumeRoleRequest.getExternalId() != null) {
            prefix = "ExternalId";
            String externalId = assumeRoleRequest.getExternalId();
            request.addParameter(prefix, StringUtils.fromString(externalId));
        }
        if (assumeRoleRequest.getSerialNumber() != null) {
            prefix = "SerialNumber";
            String serialNumber = assumeRoleRequest.getSerialNumber();
            request.addParameter(prefix, StringUtils.fromString(serialNumber));
        }
        if (assumeRoleRequest.getTokenCode() != null) {
            prefix = "TokenCode";
            String tokenCode = assumeRoleRequest.getTokenCode();
            request.addParameter(prefix, StringUtils.fromString(tokenCode));
        }
        return request;
    }
}

