/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.logging;

import com.amazonaws.logging.AndroidLog;
import com.amazonaws.logging.ApacheCommonsLogging;
import com.amazonaws.logging.Log;
import java.util.HashMap;
import java.util.Map;

public class LogFactory {
    private static final String APACHE_COMMONS_LOGGING_LOGFACTORY = "org.apache.commons.logging.LogFactory";
    private static Map<String, Log> logMap = new HashMap<String, Log>();

    public static synchronized Log getLog(Class clazz) {
        Log log = logMap.get(clazz.getSimpleName());
        if (log == null) {
            if (LogFactory.checkApacheCommonsLoggingExists()) {
                log = new ApacheCommonsLogging(clazz);
                logMap.put(clazz.getSimpleName(), log);
            } else {
                log = new AndroidLog(clazz.getSimpleName());
                logMap.put(clazz.getSimpleName(), log);
            }
        }
        return log;
    }

    public static synchronized Log getLog(String string) {
        Log log = logMap.get(string);
        if (log == null) {
            if (LogFactory.checkApacheCommonsLoggingExists()) {
                log = new ApacheCommonsLogging(string);
                logMap.put(string, log);
            } else {
                log = new AndroidLog(string);
                logMap.put(string, log);
            }
        }
        return log;
    }

    private static boolean checkApacheCommonsLoggingExists() {
        try {
            Class<?> classObject = Class.forName(APACHE_COMMONS_LOGGING_LOGFACTORY);
            return true;
        }
        catch (ClassNotFoundException cnfe) {
            return false;
        }
        catch (Exception ex) {
            android.util.Log.e((String)LogFactory.class.getSimpleName(), (String)ex.getMessage());
            return false;
        }
    }
}

