/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.transform;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.transform.AbstractErrorUnmarshaller;
import com.amazonaws.util.XpathUtils;
import org.w3c.dom.Node;

public class StandardErrorUnmarshaller
extends AbstractErrorUnmarshaller<Node> {
    public StandardErrorUnmarshaller() {
    }

    protected StandardErrorUnmarshaller(Class<? extends AmazonServiceException> exceptionClass) {
        super(exceptionClass);
    }

    @Override
    public AmazonServiceException unmarshall(Node in) throws Exception {
        String errorCode = this.parseErrorCode(in);
        String errorType = XpathUtils.asString("ErrorResponse/Error/Type", in);
        String requestId = XpathUtils.asString("ErrorResponse/RequestId", in);
        String message = XpathUtils.asString("ErrorResponse/Error/Message", in);
        AmazonServiceException ase = this.newException(message);
        ase.setErrorCode(errorCode);
        ase.setRequestId(requestId);
        if (errorType == null) {
            ase.setErrorType(AmazonServiceException.ErrorType.Unknown);
        } else if ("Receiver".equalsIgnoreCase(errorType)) {
            ase.setErrorType(AmazonServiceException.ErrorType.Service);
        } else if ("Sender".equalsIgnoreCase(errorType)) {
            ase.setErrorType(AmazonServiceException.ErrorType.Client);
        }
        return ase;
    }

    public String parseErrorCode(Node in) throws Exception {
        return XpathUtils.asString("ErrorResponse/Error/Code", in);
    }

    public String getErrorPropertyPath(String property) {
        return "ErrorResponse/Error/" + property;
    }
}

