/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.util;

import com.amazonaws.Protocol;
import java.net.URI;
import java.net.URISyntaxException;

public class URIBuilder {
    private static final String DEFAULT_SCHEME = Protocol.HTTPS.toString();
    private static final int DEFAULT_PORT = -1;
    private String scheme;
    private String userInfo;
    private String host;
    private int port;
    private String path;
    private String query;
    private String fragment;

    private URIBuilder() {
        this.scheme = DEFAULT_SCHEME;
        this.port = -1;
    }

    private URIBuilder(URI uri) {
        this.scheme = uri.getScheme();
        this.userInfo = uri.getUserInfo();
        this.host = uri.getHost();
        this.port = uri.getPort();
        this.path = uri.getPath();
        this.query = uri.getQuery();
        this.fragment = uri.getFragment();
    }

    public static URIBuilder builder() {
        return new URIBuilder();
    }

    public static URIBuilder builder(URI uri) {
        return new URIBuilder(uri);
    }

    public URIBuilder scheme(String scheme) {
        this.scheme = scheme;
        return this;
    }

    public URIBuilder userInfo(String userInfo) {
        this.userInfo = userInfo;
        return this;
    }

    public URIBuilder host(String host) {
        this.host = host;
        return this;
    }

    public URIBuilder port(int port) {
        this.port = port;
        return this;
    }

    public URIBuilder path(String path) {
        this.path = path;
        return this;
    }

    public URIBuilder query(String query) {
        this.query = query;
        return this;
    }

    public URIBuilder fragment(String fragment) {
        this.fragment = fragment;
        return this;
    }

    public URI build() throws URISyntaxException {
        return new URI(this.scheme, this.userInfo, this.host, this.port, this.path, this.query, this.fragment);
    }
}

