/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.internal.keyvaluestore;

import android.security.keystore.KeyGenParameterSpec;
import androidx.annotation.RequiresApi;
import com.amazonaws.internal.keyvaluestore.KeyNotFoundException;
import com.amazonaws.internal.keyvaluestore.KeyNotGeneratedException;
import com.amazonaws.internal.keyvaluestore.KeyProvider;
import com.amazonaws.logging.Log;
import com.amazonaws.logging.LogFactory;
import java.security.Key;
import java.security.KeyStore;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;

@RequiresApi(api=23)
class KeyProvider23
implements KeyProvider {
    private static final Log logger = LogFactory.getLog(KeyProvider23.class);
    private static final String AES_KEY_ALGORITHM = "AES";
    private static final int CIPHER_AES_GCM_NOPADDING_KEY_LENGTH_IN_BITS = 256;
    private static final String ANDROID_KEY_STORE_NAME = "AndroidKeyStore";
    static final String AWS_KEY_VALUE_STORE_VERSION_1_KEY_STORE_ALIAS_FOR_AES_SUFFIX = ".aesKeyStoreAlias";

    KeyProvider23() {
    }

    @Override
    public synchronized Key retrieveKey(String keyAlias) throws KeyNotFoundException {
        try {
            KeyStore keyStore = KeyStore.getInstance(ANDROID_KEY_STORE_NAME);
            keyStore.load(null);
            if (keyStore.containsAlias(keyAlias)) {
                logger.debug("AndroidKeyStore contains keyAlias " + keyAlias);
                logger.debug("Loading the encryption key from Android KeyStore.");
                Key key = keyStore.getKey(keyAlias, null);
                if (key != null) {
                    return key;
                }
                throw new KeyNotFoundException("Key is null even though the keyAlias: " + keyAlias + " is present in " + ANDROID_KEY_STORE_NAME);
            }
            throw new KeyNotFoundException("AndroidKeyStore does not contain the keyAlias: " + keyAlias);
        }
        catch (Exception ex) {
            throw new KeyNotFoundException("Error occurred while accessing AndroidKeyStore to retrieve the key for keyAlias: " + keyAlias, ex);
        }
    }

    @Override
    public synchronized Key generateKey(String keyAlias) throws KeyNotGeneratedException {
        try {
            KeyStore keyStore = KeyStore.getInstance(ANDROID_KEY_STORE_NAME);
            keyStore.load(null);
            if (!keyStore.containsAlias(keyAlias)) {
                KeyGenerator generator = KeyGenerator.getInstance(AES_KEY_ALGORITHM, ANDROID_KEY_STORE_NAME);
                generator.init((AlgorithmParameterSpec)new KeyGenParameterSpec.Builder(keyAlias, 3).setBlockModes(new String[]{"GCM"}).setEncryptionPaddings(new String[]{"NoPadding"}).setKeySize(256).setRandomizedEncryptionRequired(false).build());
                SecretKey key = generator.generateKey();
                logger.info("Generated the encryption key identified by the keyAlias: " + keyAlias + " using " + ANDROID_KEY_STORE_NAME);
                return key;
            }
            throw new KeyNotGeneratedException("Key already exists for the keyAlias: " + keyAlias + " in " + ANDROID_KEY_STORE_NAME);
        }
        catch (Exception ex) {
            throw new KeyNotGeneratedException("Cannot generate a key for alias: " + keyAlias + " in " + ANDROID_KEY_STORE_NAME, ex);
        }
    }

    @Override
    public synchronized void deleteKey(String keyAlias) {
        try {
            KeyStore keyStore = KeyStore.getInstance(ANDROID_KEY_STORE_NAME);
            keyStore.load(null);
            keyStore.deleteEntry(keyAlias);
        }
        catch (Exception ex) {
            logger.error("Error in deleting the key for keyAlias: " + keyAlias + " from Android KeyStore.", ex);
        }
    }
}

