/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitoidentity.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.cognitoidentity.model.RoleMapping;
import com.amazonaws.services.cognitoidentity.model.SetIdentityPoolRolesRequest;
import com.amazonaws.services.cognitoidentity.model.transform.RoleMappingJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.AwsJsonWriter;
import com.amazonaws.util.json.JsonUtils;
import java.io.StringWriter;
import java.util.Map;

public class SetIdentityPoolRolesRequestMarshaller
implements Marshaller<Request<SetIdentityPoolRolesRequest>, SetIdentityPoolRolesRequest> {
    @Override
    public Request<SetIdentityPoolRolesRequest> marshall(SetIdentityPoolRolesRequest setIdentityPoolRolesRequest) {
        if (setIdentityPoolRolesRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(SetIdentityPoolRolesRequest)");
        }
        DefaultRequest<SetIdentityPoolRolesRequest> request = new DefaultRequest<SetIdentityPoolRolesRequest>(setIdentityPoolRolesRequest, "AmazonCognitoIdentity");
        String target = "AWSCognitoIdentityService.SetIdentityPoolRoles";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/";
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = new StringWriter();
            AwsJsonWriter jsonWriter = JsonUtils.getJsonWriter(stringWriter);
            jsonWriter.beginObject();
            if (setIdentityPoolRolesRequest.getIdentityPoolId() != null) {
                String identityPoolId = setIdentityPoolRolesRequest.getIdentityPoolId();
                jsonWriter.name("IdentityPoolId");
                jsonWriter.value(identityPoolId);
            }
            if (setIdentityPoolRolesRequest.getRoles() != null) {
                Map<String, String> roles = setIdentityPoolRolesRequest.getRoles();
                jsonWriter.name("Roles");
                jsonWriter.beginObject();
                for (Map.Entry<String, Object> entry : roles.entrySet()) {
                    String rolesValue = (String)entry.getValue();
                    if (rolesValue == null) continue;
                    jsonWriter.name(entry.getKey());
                    jsonWriter.value(rolesValue);
                }
                jsonWriter.endObject();
            }
            if (setIdentityPoolRolesRequest.getRoleMappings() != null) {
                Map<String, RoleMapping> roleMappings = setIdentityPoolRolesRequest.getRoleMappings();
                jsonWriter.name("RoleMappings");
                jsonWriter.beginObject();
                for (Map.Entry<String, Object> entry : roleMappings.entrySet()) {
                    RoleMapping roleMappingsValue = (RoleMapping)entry.getValue();
                    if (roleMappingsValue == null) continue;
                    jsonWriter.name(entry.getKey());
                    RoleMappingJsonMarshaller.getInstance().marshall(roleMappingsValue, jsonWriter);
                }
                jsonWriter.endObject();
            }
            jsonWriter.endObject();
            jsonWriter.close();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        return request;
    }
}

