/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitoidentityprovider.model.transform;

import com.amazonaws.services.cognitoidentityprovider.model.EventRiskType;
import com.amazonaws.transform.JsonUnmarshallerContext;
import com.amazonaws.transform.SimpleTypeJsonUnmarshallers;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.json.AwsJsonReader;

class EventRiskTypeJsonUnmarshaller
implements Unmarshaller<EventRiskType, JsonUnmarshallerContext> {
    private static EventRiskTypeJsonUnmarshaller instance;

    EventRiskTypeJsonUnmarshaller() {
    }

    public EventRiskType unmarshall(JsonUnmarshallerContext context) throws Exception {
        AwsJsonReader reader = context.getReader();
        if (!reader.isContainer()) {
            reader.skipValue();
            return null;
        }
        EventRiskType eventRiskType = new EventRiskType();
        reader.beginObject();
        while (reader.hasNext()) {
            String name = reader.nextName();
            if (name.equals("RiskDecision")) {
                eventRiskType.setRiskDecision(SimpleTypeJsonUnmarshallers.StringJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (name.equals("RiskLevel")) {
                eventRiskType.setRiskLevel(SimpleTypeJsonUnmarshallers.StringJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (name.equals("CompromisedCredentialsDetected")) {
                eventRiskType.setCompromisedCredentialsDetected(SimpleTypeJsonUnmarshallers.BooleanJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            reader.skipValue();
        }
        reader.endObject();
        return eventRiskType;
    }

    public static EventRiskTypeJsonUnmarshaller getInstance() {
        if (instance == null) {
            instance = new EventRiskTypeJsonUnmarshaller();
        }
        return instance;
    }
}

