/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitoidentityprovider.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.cognitoidentityprovider.model.AccountTakeoverRiskConfigurationType;
import com.amazonaws.services.cognitoidentityprovider.model.CompromisedCredentialsRiskConfigurationType;
import com.amazonaws.services.cognitoidentityprovider.model.RiskExceptionConfigurationType;
import com.amazonaws.services.cognitoidentityprovider.model.SetRiskConfigurationRequest;
import com.amazonaws.services.cognitoidentityprovider.model.transform.AccountTakeoverRiskConfigurationTypeJsonMarshaller;
import com.amazonaws.services.cognitoidentityprovider.model.transform.CompromisedCredentialsRiskConfigurationTypeJsonMarshaller;
import com.amazonaws.services.cognitoidentityprovider.model.transform.RiskExceptionConfigurationTypeJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.AwsJsonWriter;
import com.amazonaws.util.json.JsonUtils;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;

public class SetRiskConfigurationRequestMarshaller
implements Marshaller<Request<SetRiskConfigurationRequest>, SetRiskConfigurationRequest> {
    public Request<SetRiskConfigurationRequest> marshall(SetRiskConfigurationRequest setRiskConfigurationRequest) {
        if (setRiskConfigurationRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(SetRiskConfigurationRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)setRiskConfigurationRequest, "AmazonCognitoIdentityProvider");
        String target = "AWSCognitoIdentityProviderService.SetRiskConfiguration";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/";
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = new StringWriter();
            AwsJsonWriter jsonWriter = JsonUtils.getJsonWriter((Writer)stringWriter);
            jsonWriter.beginObject();
            if (setRiskConfigurationRequest.getUserPoolId() != null) {
                String userPoolId = setRiskConfigurationRequest.getUserPoolId();
                jsonWriter.name("UserPoolId");
                jsonWriter.value(userPoolId);
            }
            if (setRiskConfigurationRequest.getClientId() != null) {
                String clientId = setRiskConfigurationRequest.getClientId();
                jsonWriter.name("ClientId");
                jsonWriter.value(clientId);
            }
            if (setRiskConfigurationRequest.getCompromisedCredentialsRiskConfiguration() != null) {
                CompromisedCredentialsRiskConfigurationType compromisedCredentialsRiskConfiguration = setRiskConfigurationRequest.getCompromisedCredentialsRiskConfiguration();
                jsonWriter.name("CompromisedCredentialsRiskConfiguration");
                CompromisedCredentialsRiskConfigurationTypeJsonMarshaller.getInstance().marshall(compromisedCredentialsRiskConfiguration, jsonWriter);
            }
            if (setRiskConfigurationRequest.getAccountTakeoverRiskConfiguration() != null) {
                AccountTakeoverRiskConfigurationType accountTakeoverRiskConfiguration = setRiskConfigurationRequest.getAccountTakeoverRiskConfiguration();
                jsonWriter.name("AccountTakeoverRiskConfiguration");
                AccountTakeoverRiskConfigurationTypeJsonMarshaller.getInstance().marshall(accountTakeoverRiskConfiguration, jsonWriter);
            }
            if (setRiskConfigurationRequest.getRiskExceptionConfiguration() != null) {
                RiskExceptionConfigurationType riskExceptionConfiguration = setRiskConfigurationRequest.getRiskExceptionConfiguration();
                jsonWriter.name("RiskExceptionConfiguration");
                RiskExceptionConfigurationTypeJsonMarshaller.getInstance().marshall(riskExceptionConfiguration, jsonWriter);
            }
            jsonWriter.endObject();
            jsonWriter.close();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        return request;
    }
}

